"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateTsconfig = updateTsconfig;
const devkit_1 = require("@nx/devkit");
const ts_config_1 = require("../../../utilities/ts-config");
const find_project_for_path_1 = require("nx/src/project-graph/utils/find-project-for-path");
/**
 * Updates the tsconfig paths to remove the project.
 *
 * @param schema The options provided to the schematic
 */
async function updateTsconfig(tree, schema) {
    const tsConfigPath = (0, ts_config_1.getRootTsConfigPathInTree)(tree);
    if (tree.exists(tsConfigPath)) {
        const graph = await (0, devkit_1.createProjectGraphAsync)();
        const projectMapping = (0, find_project_for_path_1.createProjectRootMappings)(graph.nodes);
        (0, devkit_1.updateJson)(tree, tsConfigPath, (json) => {
            for (const importPath in json.compilerOptions.paths) {
                for (const path of json.compilerOptions.paths[importPath]) {
                    const project = (0, find_project_for_path_1.findProjectForPath)((0, devkit_1.normalizePath)(path), projectMapping);
                    if (project === schema.projectName) {
                        delete json.compilerOptions.paths[importPath];
                        break;
                    }
                }
            }
            return json;
        });
    }
}
