export function reduceTicks(ticks, maxTicks) {
    if (ticks.length > maxTicks) {
        const reduced = [];
        const modulus = Math.floor(ticks.length / maxTicks);
        for (let i = 0; i < ticks.length; i++) {
            if (i % modulus === 0) {
                reduced.push(ticks[i]);
            }
        }
        ticks = reduced;
    }
    return ticks;
}
export function getTickLines(label, maxLength, maxLines) {
    const labelString = (label || '').toString();
    let totalLines = [];
    if (/\s/.test(labelString)) {
        totalLines = labelString.split(/\s+/).reduce((lines, line) => {
            const last = (lines.pop() || '') + ' ';
            return last.length + line.length > maxLength ? [...lines, last.trim(), line.trim()] : [...lines, last + line];
        }, []);
    }
    else {
        let startIndex = 0;
        while (startIndex < labelString.length) {
            totalLines.push(labelString.substring(startIndex, startIndex + maxLength));
            startIndex += maxLength;
        }
    }
    if (totalLines.length > maxLines) {
        totalLines = totalLines.splice(0, maxLines);
        totalLines[totalLines.length - 1] += '...';
    }
    return totalLines;
}
//# sourceMappingURL=data:application/json;base64,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