// Robert Penner's easeOutExpo
function easeOutExpo(t, b, c, d) {
    return (c * (-Math.pow(2, (-10 * t) / d) + 1) * 1024) / 1023 + b;
}
/**
 * Counts from a number to the end incrementally.
 */
export function count(countFrom, countTo, countDecimals, countDuration, callback) {
    const startVal = Number(countFrom);
    const endVal = Number(countTo);
    const countDown = startVal > endVal;
    const decimals = Math.max(0, countDecimals);
    const dec = Math.pow(10, decimals);
    const duration = Number(countDuration) * 1000;
    let startTime;
    function runCount(timestamp) {
        let frameVal;
        const progress = timestamp - startTime;
        if (countDown) {
            frameVal = startVal - easeOutExpo(progress, 0, startVal - endVal, duration);
        }
        else {
            frameVal = easeOutExpo(progress, startVal, endVal - startVal, duration);
        }
        if (countDown) {
            frameVal = frameVal < endVal ? endVal : frameVal;
        }
        else {
            frameVal = frameVal > endVal ? endVal : frameVal;
        }
        frameVal = Math.round(frameVal * dec) / dec;
        const tick = progress < duration;
        callback({
            value: frameVal,
            progress,
            timestamp,
            finished: !tick
        });
        if (tick) {
            return requestAnimationFrame(val => runCount(val));
        }
    }
    return requestAnimationFrame(timestamp => {
        startTime = timestamp;
        return runCount(timestamp);
    });
}
/**
 * Determine decimals places
 *
 * @export
 */
export function decimalChecker(countTo) {
    const endVal = Number(countTo);
    if (endVal % 1 !== 0 && Math.abs(endVal) <= 10) {
        return 2;
    }
    return 0;
}
//# sourceMappingURL=data:application/json;base64,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