import { timeFormat } from 'd3-time-format';
export function tickFormat(fieldType, groupByType) {
    return function (label) {
        if (label === 'No Value' || label === 'Other') {
            return label;
        }
        if (fieldType === 'date' && groupByType === 'groupBy') {
            const formatter = timeFormat('MM/DD/YYYY');
            return formatter(label);
        }
        return label.toString();
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGljay1mb3JtYXQuaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3dpbWxhbmUvbmd4LWNoYXJ0cy9zcmMvbGliL2NvbW1vbi90aWNrLWZvcm1hdC5oZWxwZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBRTVDLE1BQU0sVUFBVSxVQUFVLENBQUMsU0FBUyxFQUFFLFdBQVc7SUFDL0MsT0FBTyxVQUFVLEtBQWE7UUFDNUIsSUFBSSxLQUFLLEtBQUssVUFBVSxJQUFJLEtBQUssS0FBSyxPQUFPLEVBQUU7WUFDN0MsT0FBTyxLQUFLLENBQUM7U0FDZDtRQUNELElBQUksU0FBUyxLQUFLLE1BQU0sSUFBSSxXQUFXLEtBQUssU0FBUyxFQUFFO1lBQ3JELE1BQU0sU0FBUyxHQUFHLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUMzQyxPQUFPLFNBQVMsQ0FBTSxLQUFLLENBQUMsQ0FBQztTQUM5QjtRQUVELE9BQU8sS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQzFCLENBQUMsQ0FBQztBQUNKLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyB0aW1lRm9ybWF0IH0gZnJvbSAnZDMtdGltZS1mb3JtYXQnO1xuXG5leHBvcnQgZnVuY3Rpb24gdGlja0Zvcm1hdChmaWVsZFR5cGUsIGdyb3VwQnlUeXBlKTogKGxhYmVsOiBzdHJpbmcpID0+IHN0cmluZyB7XG4gIHJldHVybiBmdW5jdGlvbiAobGFiZWw6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgaWYgKGxhYmVsID09PSAnTm8gVmFsdWUnIHx8IGxhYmVsID09PSAnT3RoZXInKSB7XG4gICAgICByZXR1cm4gbGFiZWw7XG4gICAgfVxuICAgIGlmIChmaWVsZFR5cGUgPT09ICdkYXRlJyAmJiBncm91cEJ5VHlwZSA9PT0gJ2dyb3VwQnknKSB7XG4gICAgICBjb25zdCBmb3JtYXR0ZXIgPSB0aW1lRm9ybWF0KCdNTS9ERC9ZWVlZJyk7XG4gICAgICByZXR1cm4gZm9ybWF0dGVyKDxhbnk+bGFiZWwpO1xuICAgIH1cblxuICAgIHJldHVybiBsYWJlbC50b1N0cmluZygpO1xuICB9O1xufVxuIl19