// If we don't check whether 'window' and 'global' variables are defined,
// code will fail in browser/node with 'variable is undefined' error.
let root;
if (typeof window !== 'undefined') {
    root = window;
}
else if (typeof global !== 'undefined') {
    root = global;
}
// tslint:disable-next-line:variable-name
export const MouseEvent = root.MouseEvent;
export function createMouseEvent(name, bubbles = false, cancelable = true) {
    // Calling new of an event does not work correctly on IE. The following is a tested workaround
    // See https://stackoverflow.com/questions/27176983/dispatchevent-not-working-in-ie11
    if (typeof MouseEvent === 'function') {
        // Sane browsers
        return new MouseEvent(name, { bubbles, cancelable });
    }
    else {
        // IE
        const event = document.createEvent('MouseEvent');
        event.initEvent(name, bubbles, cancelable);
        return event;
    }
}
//# sourceMappingURL=data:application/json;base64,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