import { ScaleType } from '../common/types/scale-type.enum';
export const colorSets = [
    {
        name: 'vivid',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#647c8a',
            '#3f51b5',
            '#2196f3',
            '#00b862',
            '#afdf0a',
            '#a7b61a',
            '#f3e562',
            '#ff9800',
            '#ff5722',
            '#ff4514'
        ]
    },
    {
        name: 'natural',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#bf9d76',
            '#e99450',
            '#d89f59',
            '#f2dfa7',
            '#a5d7c6',
            '#7794b1',
            '#afafaf',
            '#707160',
            '#ba9383',
            '#d9d5c3'
        ]
    },
    {
        name: 'cool',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: [
            '#a8385d',
            '#7aa3e5',
            '#a27ea8',
            '#aae3f5',
            '#adcded',
            '#a95963',
            '#8796c0',
            '#7ed3ed',
            '#50abcc',
            '#ad6886'
        ]
    },
    {
        name: 'fire',
        selectable: true,
        group: ScaleType.Ordinal,
        domain: ['#ff3d00', '#bf360c', '#ff8f00', '#ff6f00', '#ff5722', '#e65100', '#ffca28', '#ffab00']
    },
    {
        name: 'solar',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#fff8e1',
            '#ffecb3',
            '#ffe082',
            '#ffd54f',
            '#ffca28',
            '#ffc107',
            '#ffb300',
            '#ffa000',
            '#ff8f00',
            '#ff6f00'
        ]
    },
    {
        name: 'air',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#e1f5fe',
            '#b3e5fc',
            '#81d4fa',
            '#4fc3f7',
            '#29b6f6',
            '#03a9f4',
            '#039be5',
            '#0288d1',
            '#0277bd',
            '#01579b'
        ]
    },
    {
        name: 'aqua',
        selectable: true,
        group: ScaleType.Linear,
        domain: [
            '#e0f7fa',
            '#b2ebf2',
            '#80deea',
            '#4dd0e1',
            '#26c6da',
            '#00bcd4',
            '#00acc1',
            '#0097a7',
            '#00838f',
            '#006064'
        ]
    },
    {
        name: 'flame',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#A10A28',
            '#D3342D',
            '#EF6D49',
            '#FAAD67',
            '#FDDE90',
            '#DBED91',
            '#A9D770',
            '#6CBA67',
            '#2C9653',
            '#146738'
        ]
    },
    {
        name: 'ocean',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#1D68FB',
            '#33C0FC',
            '#4AFFFE',
            '#AFFFFF',
            '#FFFC63',
            '#FDBD2D',
            '#FC8A25',
            '#FA4F1E',
            '#FA141B',
            '#BA38D1'
        ]
    },
    {
        name: 'forest',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#55C22D',
            '#C1F33D',
            '#3CC099',
            '#AFFFFF',
            '#8CFC9D',
            '#76CFFA',
            '#BA60FB',
            '#EE6490',
            '#C42A1C',
            '#FC9F32'
        ]
    },
    {
        name: 'horizon',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#2597FB',
            '#65EBFD',
            '#99FDD0',
            '#FCEE4B',
            '#FEFCFA',
            '#FDD6E3',
            '#FCB1A8',
            '#EF6F7B',
            '#CB96E8',
            '#EFDEE0'
        ]
    },
    {
        name: 'neons',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#FF3333',
            '#FF33FF',
            '#CC33FF',
            '#0000FF',
            '#33CCFF',
            '#33FFFF',
            '#33FF66',
            '#CCFF33',
            '#FFCC00',
            '#FF6600'
        ]
    },
    {
        name: 'picnic',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#FAC51D',
            '#66BD6D',
            '#FAA026',
            '#29BB9C',
            '#E96B56',
            '#55ACD2',
            '#B7332F',
            '#2C83C9',
            '#9166B8',
            '#92E7E8'
        ]
    },
    {
        name: 'night',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#2B1B5A',
            '#501356',
            '#183356',
            '#28203F',
            '#391B3C',
            '#1E2B3C',
            '#120634',
            '#2D0432',
            '#051932',
            '#453080',
            '#75267D',
            '#2C507D',
            '#4B3880',
            '#752F7D',
            '#35547D'
        ]
    },
    {
        name: 'nightLights',
        selectable: false,
        group: ScaleType.Ordinal,
        domain: [
            '#4e31a5',
            '#9c25a7',
            '#3065ab',
            '#57468b',
            '#904497',
            '#46648b',
            '#32118d',
            '#a00fb3',
            '#1052a2',
            '#6e51bd',
            '#b63cc3',
            '#6c97cb',
            '#8671c1',
            '#b455be',
            '#7496c3'
        ]
    }
];
//# sourceMappingURL=data:application/json;base64,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