import { ElementRef, EventEmitter, OnChanges, SimpleChanges } from '@angular/core';
import { DataItem } from '../models/chart-data.model';
import { BarOrientation } from '../common/types/bar-orientation.enum';
import { Gradient } from '../common/types/gradient.interface';
import * as i0 from "@angular/core";
export declare class BarComponent implements OnChanges {
    fill: string;
    data: DataItem;
    width: number;
    height: number;
    x: number;
    y: number;
    orientation: BarOrientation;
    roundEdges: boolean;
    gradient: boolean;
    offset: number;
    isActive: boolean;
    stops: Gradient[];
    animations: boolean;
    ariaLabel: string;
    noBarWhenZero: boolean;
    select: EventEmitter<DataItem>;
    activate: EventEmitter<DataItem>;
    deactivate: EventEmitter<DataItem>;
    element: HTMLElement;
    path: string;
    gradientId: string;
    gradientFill: string;
    gradientStops: Gradient[];
    hasGradient: boolean;
    hideBar: boolean;
    constructor(element: ElementRef);
    ngOnChanges(changes: SimpleChanges): void;
    update(): void;
    loadAnimation(): void;
    updatePathEl(): void;
    getGradient(): Gradient[];
    getStartingPath(): string;
    getPath(): string;
    getRadius(): number;
    getStartOpacity(): number;
    get edges(): boolean[];
    onMouseEnter(): void;
    onMouseLeave(): void;
    private checkToHideBar;
    static ɵfac: i0.ɵɵFactoryDeclaration<BarComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BarComponent, "g[ngx-charts-bar]", never, { "fill": "fill"; "data": "data"; "width": "width"; "height": "height"; "x": "x"; "y": "y"; "orientation": "orientation"; "roundEdges": "roundEdges"; "gradient": "gradient"; "offset": "offset"; "isActive": "isActive"; "stops": "stops"; "animations": "animations"; "ariaLabel": "ariaLabel"; "noBarWhenZero": "noBarWhenZero"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; }, never, never>;
}
