import { EventEmitter, TemplateRef } from '@angular/core';
import { BaseChartComponent } from '../common/base-chart.component';
import { ColorHelper } from '../common/color.helper';
import { BoxChartMultiSeries, BoxChartSeries, IBoxModel, StringOrNumberOrDate } from '../models/chart-data.model';
import { ScaleLinear, ScaleBand } from 'd3-scale';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import { LegendPosition, LegendOptions } from '../common/types/legend.model';
import * as i0 from "@angular/core";
export declare class BoxChartComponent extends BaseChartComponent {
    /** Show or hide the legend. */
    legend: boolean;
    legendPosition: LegendPosition;
    legendTitle: string;
    /** I think it is better to handle legend options as single Input object of type ILegendOptions */
    legendOptionsConfig: LegendOptions;
    showGridLines: boolean;
    xAxis: boolean;
    yAxis: boolean;
    showXAxisLabel: boolean;
    showYAxisLabel: boolean;
    roundDomains: boolean;
    xAxisLabel: string;
    yAxisLabel: string;
    roundEdges: boolean;
    strokeColor: string;
    strokeWidth: number;
    tooltipDisabled: boolean;
    gradient: boolean;
    wrapTicks: boolean;
    select: EventEmitter<IBoxModel>;
    activate: EventEmitter<IBoxModel>;
    deactivate: EventEmitter<IBoxModel>;
    tooltipTemplate: TemplateRef<any>;
    /** Input Data, this came from Base Chart Component. */
    results: BoxChartMultiSeries;
    /** Chart Dimensions, this came from Base Chart Component. */
    dims: ViewDimensions;
    /** Color data. */
    colors: ColorHelper;
    /** Transform string css attribute for the chart container */
    transform: string;
    /** Chart Margins (For each side, counterclock wise). */
    margin: [number, number, number, number];
    /** Legend Options object to handle positioning, title, colors and domain. */
    legendOptions: LegendOptions;
    xScale: ScaleBand<string>;
    yScale: ScaleLinear<number, number>;
    xDomain: StringOrNumberOrDate[];
    yDomain: number[];
    seriesDomain: string[];
    /** Chart X axis dimension. */
    xAxisHeight: number;
    /** Chart Y axis dimension. */
    yAxisWidth: number;
    trackBy(index: number, item: BoxChartSeries): StringOrNumberOrDate;
    update(): void;
    setColors(): void;
    setScales(): void;
    getXScale(domain: Array<string | number | Date>, width: number): ScaleBand<string>;
    getYScale(domain: number[], height: number): ScaleLinear<number, number>;
    getUniqueBoxChartXDomainValues(results: BoxChartMultiSeries): (string | number | Date)[];
    getXDomain(): Array<string | number | Date>;
    getYDomain(): number[];
    getSeriesDomain(): string[];
    updateYAxisWidth({ width }: {
        width: any;
    }): void;
    updateXAxisHeight({ height }: {
        height: any;
    }): void;
    onClick(data: IBoxModel): void;
    onActivate(data: IBoxModel): void;
    onDeactivate(data: IBoxModel): void;
    private getLegendOptions;
    static ɵfac: i0.ɵɵFactoryDeclaration<BoxChartComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BoxChartComponent, "ngx-charts-box-chart", never, { "legend": "legend"; "legendPosition": "legendPosition"; "legendTitle": "legendTitle"; "legendOptionsConfig": "legendOptionsConfig"; "showGridLines": "showGridLines"; "xAxis": "xAxis"; "yAxis": "yAxis"; "showXAxisLabel": "showXAxisLabel"; "showYAxisLabel": "showYAxisLabel"; "roundDomains": "roundDomains"; "xAxisLabel": "xAxisLabel"; "yAxisLabel": "yAxisLabel"; "roundEdges": "roundEdges"; "strokeColor": "strokeColor"; "strokeWidth": "strokeWidth"; "tooltipDisabled": "tooltipDisabled"; "gradient": "gradient"; "wrapTicks": "wrapTicks"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; }, ["tooltipTemplate"], never>;
}
