import { EventEmitter, OnChanges, SimpleChanges, TemplateRef } from '@angular/core';
import { ScaleLinear, ScaleBand } from 'd3-scale';
import { IBoxModel, BoxChartSeries, DataItem } from '../models/chart-data.model';
import { IVector2D } from '../models/coordinates.model';
import { ColorHelper } from '../common/color.helper';
import { StyleTypes } from '../common/tooltip/style.type';
import { PlacementTypes } from '../common/tooltip/position';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import * as i0 from "@angular/core";
export declare class BoxSeriesComponent implements OnChanges {
    dims: ViewDimensions;
    series: BoxChartSeries;
    xScale: ScaleBand<string>;
    yScale: ScaleLinear<number, number>;
    colors: ColorHelper;
    animations: boolean;
    strokeColor: string;
    strokeWidth: number;
    tooltipDisabled: boolean;
    tooltipTemplate: TemplateRef<any>;
    tooltipPlacement: PlacementTypes;
    tooltipType: StyleTypes;
    roundEdges: boolean;
    gradient: boolean;
    select: EventEmitter<IBoxModel>;
    activate: EventEmitter<IBoxModel>;
    deactivate: EventEmitter<IBoxModel>;
    box: IBoxModel;
    counts: DataItem[];
    quartiles: [number, number, number];
    whiskers: [number, number];
    lineCoordinates: [IVector2D, IVector2D, IVector2D, IVector2D];
    tooltipTitle: string;
    ngOnChanges(changes: SimpleChanges): void;
    onClick(data: IBoxModel): void;
    update(): void;
    getBoxQuantiles(inputData: Array<number | Date>): [number, number, number];
    getLinesCoordinates(seriesName: string, whiskers: [number, number], quartiles: [number, number, number], barWidth: number): [IVector2D, IVector2D, IVector2D, IVector2D];
    updateTooltipSettings(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<BoxSeriesComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BoxSeriesComponent, "g[ngx-charts-box-series]", never, { "dims": "dims"; "series": "series"; "xScale": "xScale"; "yScale": "yScale"; "colors": "colors"; "animations": "animations"; "strokeColor": "strokeColor"; "strokeWidth": "strokeWidth"; "tooltipDisabled": "tooltipDisabled"; "tooltipTemplate": "tooltipTemplate"; "tooltipPlacement": "tooltipPlacement"; "tooltipType": "tooltipType"; "roundEdges": "roundEdges"; "gradient": "gradient"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; }, never, never>;
}
