import { SimpleChanges, EventEmitter, OnChanges, TemplateRef, OnInit } from '@angular/core';
import { ColorHelper } from '../common/color.helper';
import { BubbleChartSeries } from '../models/chart-data.model';
import { PlacementTypes } from '../common/tooltip/position';
import { StyleTypes } from '../common/tooltip/style.type';
import { ScaleType } from '../common/types/scale-type.enum';
import * as i0 from "@angular/core";
export declare class BubbleSeriesComponent implements OnChanges, OnInit {
    private platformId;
    data: BubbleChartSeries;
    xScale: any;
    yScale: any;
    rScale: any;
    xScaleType: ScaleType;
    yScaleType: ScaleType;
    colors: ColorHelper;
    visibleValue: any;
    activeEntries: any[];
    xAxisLabel: string;
    yAxisLabel: string;
    tooltipDisabled: boolean;
    tooltipTemplate: TemplateRef<any>;
    select: EventEmitter<any>;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    areaPath: any;
    circles: any[];
    placementTypes: typeof PlacementTypes;
    styleTypes: typeof StyleTypes;
    isSSR: boolean;
    constructor(platformId: any);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    update(): void;
    getCircles(): any[];
    getTooltipText(circle: any): string;
    onClick(data: any): void;
    isActive(entry: any): boolean;
    isVisible(circle: any): boolean;
    activateCircle(circle: any): void;
    deactivateCircle(circle: any): void;
    trackBy(index: any, circle: any): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<BubbleSeriesComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<BubbleSeriesComponent, "g[ngx-charts-bubble-series]", never, { "data": "data"; "xScale": "xScale"; "yScale": "yScale"; "rScale": "rScale"; "xScaleType": "xScaleType"; "yScaleType": "yScaleType"; "colors": "colors"; "visibleValue": "visibleValue"; "activeEntries": "activeEntries"; "xAxisLabel": "xAxisLabel"; "yAxisLabel": "yAxisLabel"; "tooltipDisabled": "tooltipDisabled"; "tooltipTemplate": "tooltipTemplate"; }, { "select": "select"; "activate": "activate"; "deactivate": "deactivate"; }, never, never>;
}
