import { TemplateRef, EventEmitter } from '@angular/core';
import { BaseChartComponent } from '../common/base-chart.component';
import { ColorHelper } from '../common/color.helper';
import { ViewDimensions } from '../common/types/view-dimension.interface';
import { ScaleType } from '../common/types/scale-type.enum';
import { StyleTypes } from '../common/tooltip/style.type';
import { TextAnchor } from '../common/types/text-anchor.enum';
import * as i0 from "@angular/core";
interface RectItem {
    fill: string;
    height: number;
    rx: number;
    width: number;
    x: number;
    y: number;
    label: string;
    labelAnchor: string;
    tooltip: string;
    transform: string;
    data: any;
}
export declare class SankeyComponent extends BaseChartComponent {
    showLabels: boolean;
    gradient: boolean;
    tooltipDisabled: boolean;
    activeEntries: any[];
    labelFormatting: any;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    tooltipTemplate: TemplateRef<any>;
    dims: ViewDimensions;
    colors: ColorHelper;
    colorScale: any;
    transform: string;
    margin: number[];
    scaleType: ScaleType;
    valueDomain: any[];
    styleTypes: typeof StyleTypes;
    nodeRects: RectItem[];
    linkPaths: any[];
    update(): void;
    getNodeTooltipText(node: any): string;
    getLinkTooltipText(sourceNode: any, targetNode: any, value: number): string;
    getTextAnchor(node: any): TextAnchor;
    onClick(data: any): void;
    setColors(): void;
    getValueDomain(nodes: any): any[];
    static ɵfac: i0.ɵɵFactoryDeclaration<SankeyComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<SankeyComponent, "ngx-charts-sankey", never, { "showLabels": "showLabels"; "gradient": "gradient"; "tooltipDisabled": "tooltipDisabled"; "activeEntries": "activeEntries"; "labelFormatting": "labelFormatting"; }, { "activate": "activate"; "deactivate": "deactivate"; }, ["tooltipTemplate"], never>;
}
export {};
