import { NgModule, makeEnvironmentProviders } from '@angular/core';
import { SVG_ICON_REGISTRY_PROVIDER } from './svg-icon-registry.service';
import { SvgIconComponent } from './svg-icon.component';
import { SvgHttpLoader, SvgLoader } from './svg-loader';
import * as i0 from "@angular/core";
export function provideAngularSvgIcon(config = {}) {
    return makeEnvironmentProviders([
        SVG_ICON_REGISTRY_PROVIDER,
        config.loader || { provide: SvgLoader, useClass: SvgHttpLoader },
    ]);
}
export class AngularSvgIconModule {
    static forRoot(config = {}) {
        return {
            ngModule: AngularSvgIconModule,
            providers: [
                SVG_ICON_REGISTRY_PROVIDER,
                config.loader || { provide: SvgLoader, useClass: SvgHttpLoader }
            ]
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "17.0.2", ngImport: i0, type: AngularSvgIconModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "17.0.2", ngImport: i0, type: AngularSvgIconModule, imports: [SvgIconComponent], exports: [SvgIconComponent] }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "17.0.2", ngImport: i0, type: AngularSvgIconModule, imports: [SvgIconComponent] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "17.0.2", ngImport: i0, type: AngularSvgIconModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [
                        SvgIconComponent
                    ],
                    exports: [SvgIconComponent]
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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