import { Component, Input } from '@angular/core';
import { CommonModule } from '@angular/common';
import * as i0 from "@angular/core";
import * as i1 from "./svg-icon-registry.service";
class SvgIconHelper {
    constructor() {
        this.loaded = false;
    }
}
export class SvgIconComponent {
    // Adapted from ngStyle (see:  angular/packages/common/src/directives/ng_style.ts)
    set svgStyle(values) {
        this._svgStyle = values;
        if (!this.helper.differ && values) {
            this.helper.differ = this.differs.find(values).create();
        }
    }
    constructor(element, differs, renderer, iconReg, cdr) {
        this.element = element;
        this.differs = differs;
        this.renderer = renderer;
        this.iconReg = iconReg;
        this.cdr = cdr;
        this.stretch = false;
        this.applyClass = false;
        /** @deprecated since 9.1.0 */
        this.applyCss = false;
        this.helper = new SvgIconHelper();
        this._svgStyle = null;
    }
    ngOnInit() {
        this.init();
    }
    ngOnDestroy() {
        this.destroy();
    }
    ngOnChanges(changeRecord) {
        const elemSvg = this.element.nativeElement.firstChild;
        if (changeRecord.src || changeRecord.name) {
            if (this.helper.loaded) {
                this.destroy();
            }
            this.init();
        }
        if (changeRecord.stretch) {
            this.stylize();
        }
        if (changeRecord.applyClass) {
            if (this.applyClass) {
                this.setClass(elemSvg, null, this.klass);
            }
            else {
                this.setClass(elemSvg, this.klass, null);
            }
        }
        if (changeRecord.svgClass) {
            this.setClass(elemSvg, changeRecord.svgClass.previousValue, changeRecord.svgClass.currentValue);
        }
        if (changeRecord.klass) {
            const elem = this.element.nativeElement;
            this.setClass(elem, changeRecord.klass.previousValue, changeRecord.klass.currentValue);
            if (this.applyClass) {
                this.setClass(elemSvg, changeRecord.klass.previousValue, changeRecord.klass.currentValue);
            }
            else {
                this.setClass(elemSvg, changeRecord.klass.previousValue, null);
            }
        }
        if (changeRecord.viewBox) {
            if (this.helper.loaded) {
                this.destroy();
            }
            this.init();
        }
        if (changeRecord.applyCss) {
            console.warn('applyCss deprecated since 9.1.0, will be removed in 10.0.0');
            console.warn('use applyClass instead');
        }
        if (changeRecord.svgAriaLabel) {
            this.doAria(changeRecord.svgAriaLabel.currentValue);
        }
    }
    ngDoCheck() {
        if (this.helper.svg && this.helper.differ) {
            const changes = this.helper.differ.diff(this._svgStyle);
            if (changes) {
                this.applyChanges(changes);
            }
        }
    }
    init() {
        if (this.name) {
            const svgObs = this.iconReg.getSvgByName(this.name);
            if (svgObs) {
                this.helper.icnSub = svgObs.subscribe(svg => this.initSvg(svg));
            }
        }
        else if (this.src) {
            const svgObs = this.iconReg.loadSvg(this.src);
            if (svgObs) {
                this.helper.icnSub = svgObs.subscribe(svg => this.initSvg(svg));
            }
        }
        else {
            const elem = this.element.nativeElement;
            elem.innerHTML = '';
            this.cdr.markForCheck();
        }
    }
    initSvg(svg) {
        if (!this.helper.loaded && svg) {
            this.setSvg(svg);
            this.resetDiffer();
        }
    }
    destroy() {
        if (this.helper.icnSub) {
            this.helper.icnSub.unsubscribe();
        }
        this.helper = new SvgIconHelper();
    }
    resetDiffer() {
        if (this._svgStyle && !this.helper.differ) {
            this.helper.differ = this.differs.find(this._svgStyle).create();
        }
    }
    setSvg(svg) {
        if (!this.helper.loaded && svg) {
            this.helper.svg = svg;
            const icon = svg.cloneNode(true);
            const elem = this.element.nativeElement;
            elem.innerHTML = '';
            this.renderer.appendChild(elem, icon);
            this.helper.loaded = true;
            this.copyNgContentAttribute(elem, icon);
            if (this.klass && this.applyClass) {
                this.setClass(elem.firstChild, null, this.klass);
            }
            if (this.svgClass) {
                this.setClass(elem.firstChild, null, this.svgClass);
            }
            if (this.viewBox) {
                if (this.viewBox === 'auto') {
                    // Attempt to convert height & width to a viewBox.
                    const w = icon.getAttribute('width');
                    const h = icon.getAttribute('height');
                    if (h && w) {
                        const vb = `0 0 ${w} ${h}`;
                        this.renderer.setAttribute(icon, 'viewBox', vb);
                        this.renderer.removeAttribute(icon, 'width');
                        this.renderer.removeAttribute(icon, 'height');
                    }
                }
                else if (this.viewBox !== '') {
                    this.renderer.setAttribute(icon, 'viewBox', this.viewBox);
                    this.renderer.removeAttribute(icon, 'width');
                    this.renderer.removeAttribute(icon, 'height');
                }
            }
            this.stylize();
            // If there is not a svgAriaLabel and the SVG has an arial-label, then do not override
            // the SVG's aria-label.
            if (!(this.svgAriaLabel === undefined && elem.firstChild.hasAttribute('aria-label'))) {
                this.doAria(this.svgAriaLabel || '');
            }
            this.cdr.markForCheck();
        }
    }
    copyNgContentAttribute(hostElem, icon) {
        const attributes = hostElem.attributes;
        const len = attributes.length;
        for (let i = 0; i < len; i += 1) {
            const attribute = attributes.item(i);
            if (attribute && attribute.name.startsWith('_ngcontent')) {
                this.setNgContentAttribute(icon, attribute.name);
                break;
            }
        }
    }
    setNgContentAttribute(parent, attributeName) {
        this.renderer.setAttribute(parent, attributeName, '');
        const len = parent.childNodes.length;
        for (let i = 0; i < len; i += 1) {
            const child = parent.childNodes[i];
            if (child instanceof Element) {
                this.setNgContentAttribute(child, attributeName);
            }
        }
    }
    stylize() {
        if (this.helper.svg) {
            const svg = this.element.nativeElement.firstChild;
            if (this.stretch === true) {
                this.renderer.setAttribute(svg, 'preserveAspectRatio', 'none');
            }
            else if (this.stretch === false) {
                this.renderer.removeAttribute(svg, 'preserveAspectRatio');
            }
        }
    }
    applyChanges(changes) {
        changes.forEachRemovedItem((record) => this.setStyle(record.key, null));
        changes.forEachAddedItem((record) => this.setStyle(record.key, record.currentValue));
        changes.forEachChangedItem((record) => this.setStyle(record.key, record.currentValue));
    }
    setStyle(nameAndUnit, value) {
        const [name, unit] = nameAndUnit.split('.');
        value = value !== null && unit ? `${value}${unit}` : value;
        const svg = this.element.nativeElement.firstChild;
        if (value !== null) {
            this.renderer.setStyle(svg, name, value);
        }
        else {
            this.renderer.removeStyle(svg, name);
        }
    }
    setClass(target, previous, current) {
        if (target) {
            if (previous) {
                const klasses = (Array.isArray(previous) ? previous : previous.split(' ')).filter((klass) => klass);
                for (const k of klasses) {
                    this.renderer.removeClass(target, k);
                }
            }
            if (current) {
                const klasses = (Array.isArray(current) ? current : current.split(' ')).filter((klass) => klass);
                for (const k of klasses) {
                    this.renderer.addClass(target, k);
                }
            }
        }
    }
    doAria(label) {
        const svg = this.element.nativeElement.firstChild;
        if (svg) {
            if (label === '') {
                this.renderer.setAttribute(svg, 'aria-hidden', 'true');
                this.renderer.removeAttribute(svg, 'aria-label');
            }
            else {
                this.renderer.removeAttribute(svg, 'aria-hidden');
                this.renderer.setAttribute(svg, 'aria-label', label);
            }
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "17.0.2", ngImport: i0, type: SvgIconComponent, deps: [{ token: i0.ElementRef }, { token: i0.KeyValueDiffers }, { token: i0.Renderer2 }, { token: i1.SvgIconRegistryService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "17.0.2", type: SvgIconComponent, isStandalone: true, selector: "svg-icon", inputs: { src: "src", name: "name", stretch: "stretch", applyClass: "applyClass", applyCss: "applyCss", svgClass: "svgClass", klass: ["class", "klass"], viewBox: "viewBox", svgAriaLabel: "svgAriaLabel", svgStyle: "svgStyle" }, usesOnChanges: true, ngImport: i0, template: '<ng-content></ng-content>', isInline: true, dependencies: [{ kind: "ngmodule", type: CommonModule }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "17.0.2", ngImport: i0, type: SvgIconComponent, decorators: [{
            type: Component,
            args: [{
                    standalone: true,
                    imports: [CommonModule],
                    selector: 'svg-icon',
                    template: '<ng-content></ng-content>'
                }]
        }], ctorParameters: () => [{ type: i0.ElementRef }, { type: i0.KeyValueDiffers }, { type: i0.Renderer2 }, { type: i1.SvgIconRegistryService }, { type: i0.ChangeDetectorRef }], propDecorators: { src: [{
                type: Input
            }], name: [{
                type: Input
            }], stretch: [{
                type: Input
            }], applyClass: [{
                type: Input
            }], applyCss: [{
                type: Input
            }], svgClass: [{
                type: Input
            }], klass: [{
                type: Input,
                args: ['class']
            }], viewBox: [{
                type: Input
            }], svgAriaLabel: [{
                type: Input
            }], svgStyle: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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