import { InjectionToken, Optional } from '@angular/core';
import { Observable } from 'rxjs';
import { SvgLoader } from './svg-loader';
import * as i0 from "@angular/core";
export declare const SERVER_URL: InjectionToken<string>;
export declare class SvgIconRegistryService {
    private loader;
    private platformId;
    protected serverUrl: string | undefined;
    private _document;
    private document;
    private iconsByUrl;
    private iconsLoadingByUrl;
    constructor(loader: SvgLoader, platformId: Object, serverUrl: string | undefined, _document: any);
    /** Add a SVG to the registry by passing a name and the SVG. */
    addSvg(name: string, data: string): void;
    /** Load a SVG to the registry from a URL. */
    loadSvg(url: string, name?: string): Observable<SVGElement | undefined> | undefined;
    /** Get loaded SVG from registry by name. (also works by url because of blended map) */
    getSvgByName(name: string): Observable<SVGElement | undefined> | undefined;
    /** Remove a SVG from the registry by URL (or name). */
    unloadSvg(url: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<SvgIconRegistryService, [null, null, { optional: true; }, { optional: true; }]>;
    static ɵprov: i0.ɵɵInjectableDeclaration<SvgIconRegistryService>;
}
export declare function SVG_ICON_REGISTRY_PROVIDER_FACTORY(parentRegistry: SvgIconRegistryService, loader: SvgLoader, platformId: object, serverUrl?: string, document?: any): SvgIconRegistryService;
export declare const SVG_ICON_REGISTRY_PROVIDER: {
    provide: typeof SvgIconRegistryService;
    deps: (typeof SvgLoader | Optional[])[];
    useFactory: typeof SVG_ICON_REGISTRY_PROVIDER_FACTORY;
};
