import { HttpHeaders } from '@angular/common/http';
import { ApolloLink } from '@apollo/client/core';
export const httpHeaders = () => {
    return new ApolloLink((operation, forward) => {
        const { getContext, setContext } = operation;
        const context = getContext();
        if (context.headers) {
            setContext({
                ...context,
                headers: new HttpHeaders(context.headers),
            });
        }
        return forward(operation);
    });
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9oZWFkZXJzL3NyYy9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sc0JBQXNCLENBQUM7QUFDbkQsT0FBTyxFQUFFLFVBQVUsRUFBdUIsTUFBTSxxQkFBcUIsQ0FBQztBQUV0RSxNQUFNLENBQUMsTUFBTSxXQUFXLEdBQUcsR0FBRyxFQUFFO0lBQzlCLE9BQU8sSUFBSSxVQUFVLENBQUMsQ0FBQyxTQUFvQixFQUFFLE9BQWlCLEVBQUUsRUFBRTtRQUNoRSxNQUFNLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxHQUFHLFNBQVMsQ0FBQztRQUM3QyxNQUFNLE9BQU8sR0FBRyxVQUFVLEVBQUUsQ0FBQztRQUU3QixJQUFJLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQztZQUNwQixVQUFVLENBQUM7Z0JBQ1QsR0FBRyxPQUFPO2dCQUNWLE9BQU8sRUFBRSxJQUFJLFdBQVcsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDO2FBQzFDLENBQUMsQ0FBQztRQUNMLENBQUM7UUFFRCxPQUFPLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QixDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEh0dHBIZWFkZXJzIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uL2h0dHAnO1xuaW1wb3J0IHsgQXBvbGxvTGluaywgTmV4dExpbmssIE9wZXJhdGlvbiB9IGZyb20gJ0BhcG9sbG8vY2xpZW50L2NvcmUnO1xuXG5leHBvcnQgY29uc3QgaHR0cEhlYWRlcnMgPSAoKSA9PiB7XG4gIHJldHVybiBuZXcgQXBvbGxvTGluaygob3BlcmF0aW9uOiBPcGVyYXRpb24sIGZvcndhcmQ6IE5leHRMaW5rKSA9PiB7XG4gICAgY29uc3QgeyBnZXRDb250ZXh0LCBzZXRDb250ZXh0IH0gPSBvcGVyYXRpb247XG4gICAgY29uc3QgY29udGV4dCA9IGdldENvbnRleHQoKTtcblxuICAgIGlmIChjb250ZXh0LmhlYWRlcnMpIHtcbiAgICAgIHNldENvbnRleHQoe1xuICAgICAgICAuLi5jb250ZXh0LFxuICAgICAgICBoZWFkZXJzOiBuZXcgSHR0cEhlYWRlcnMoY29udGV4dC5oZWFkZXJzKSxcbiAgICAgIH0pO1xuICAgIH1cblxuICAgIHJldHVybiBmb3J3YXJkKG9wZXJhdGlvbik7XG4gIH0pO1xufTtcbiJdfQ==