import { print } from 'graphql';
import { Injectable } from '@angular/core';
import { ApolloLink, Observable as LinkObservable, } from '@apollo/client/core';
import { pick } from './http-batch-link';
import { createHeadersWithClientAwareness, fetch, mergeHeaders } from './utils';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
// XXX find a better name for it
export class HttpLinkHandler extends ApolloLink {
    httpClient;
    options;
    requester;
    print = print;
    constructor(httpClient, options) {
        super();
        this.httpClient = httpClient;
        this.options = options;
        if (this.options.operationPrinter) {
            this.print = this.options.operationPrinter;
        }
        this.requester = (operation) => new LinkObservable((observer) => {
            const context = operation.getContext();
            let method = pick(context, this.options, 'method');
            const includeQuery = pick(context, this.options, 'includeQuery');
            const includeExtensions = pick(context, this.options, 'includeExtensions');
            const url = pick(context, this.options, 'uri');
            const withCredentials = pick(context, this.options, 'withCredentials');
            const useMultipart = pick(context, this.options, 'useMultipart');
            const useGETForQueries = this.options.useGETForQueries === true;
            const isQuery = operation.query.definitions.some(def => def.kind === 'OperationDefinition' && def.operation === 'query');
            if (useGETForQueries && isQuery) {
                method = 'GET';
            }
            const req = {
                method,
                url: typeof url === 'function' ? url(operation) : url,
                body: {
                    operationName: operation.operationName,
                    variables: operation.variables,
                },
                options: {
                    withCredentials,
                    useMultipart,
                    headers: this.options.headers,
                },
            };
            if (includeExtensions) {
                req.body.extensions = operation.extensions;
            }
            if (includeQuery) {
                req.body.query = this.print(operation.query);
            }
            const headers = createHeadersWithClientAwareness(context);
            req.options.headers = mergeHeaders(req.options.headers, headers);
            const sub = fetch(req, this.httpClient, this.options.extractFiles).subscribe({
                next: response => {
                    operation.setContext({ response });
                    observer.next(response.body);
                },
                error: err => observer.error(err),
                complete: () => observer.complete(),
            });
            return () => {
                if (!sub.closed) {
                    sub.unsubscribe();
                }
            };
        });
    }
    request(op) {
        return this.requester(op);
    }
}
export class HttpLink {
    httpClient;
    constructor(httpClient) {
        this.httpClient = httpClient;
    }
    create(options) {
        return new HttpLinkHandler(this.httpClient, options);
    }
    static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: HttpLink, deps: [{ token: i1.HttpClient }], target: i0.ɵɵFactoryTarget.Injectable });
    static ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: HttpLink, providedIn: 'root' });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: HttpLink, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: () => [{ type: i1.HttpClient }] });
//# sourceMappingURL=data:application/json;base64,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