import { setContext } from '@apollo/client/link/context';
import { ApolloLink } from '@apollo/client/link/core';
import { createPersistedQueryLink as _createPersistedQueryLink } from '@apollo/client/link/persisted-queries';
const transformLink = setContext((_, context) => {
    const ctx = {};
    if (context.http) {
        ctx.includeQuery = context.http.includeQuery;
        ctx.includeExtensions = context.http.includeExtensions;
    }
    if (context.fetchOptions && context.fetchOptions.method) {
        ctx.method = context.fetchOptions.method;
    }
    return ctx;
});
export const createPersistedQueryLink = (options) => ApolloLink.from([_createPersistedQueryLink(options), transformLink]);
//# sourceMappingURL=data:application/json;base64,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