import { from, Observable } from 'rxjs';
import { NetworkStatus } from '@apollo/client/core';
import { fixObservable, wrapWithZone } from './utils';
function useInitialLoading(obsQuery) {
    return function useInitialLoadingOperator(source) {
        return new Observable(function useInitialLoadingSubscription(subscriber) {
            const currentResult = obsQuery.getCurrentResult();
            const { loading, errors, error, partial, data } = currentResult;
            const { partialRefetch, fetchPolicy } = obsQuery.options;
            const hasError = errors || error;
            if (partialRefetch &&
                partial &&
                (!data || Object.keys(data).length === 0) &&
                fetchPolicy !== 'cache-only' &&
                !loading &&
                !hasError) {
                subscriber.next({
                    ...currentResult,
                    loading: true,
                    networkStatus: NetworkStatus.loading,
                });
            }
            return source.subscribe(subscriber);
        });
    };
}
export class QueryRef {
    obsQuery;
    valueChanges;
    queryId;
    constructor(obsQuery, ngZone, options) {
        this.obsQuery = obsQuery;
        const wrapped = wrapWithZone(from(fixObservable(this.obsQuery)), ngZone);
        this.valueChanges = options.useInitialLoading
            ? wrapped.pipe(useInitialLoading(this.obsQuery))
            : wrapped;
        this.queryId = this.obsQuery.queryId;
    }
    // ObservableQuery's methods
    get options() {
        return this.obsQuery.options;
    }
    get variables() {
        return this.obsQuery.variables;
    }
    result() {
        return this.obsQuery.result();
    }
    getCurrentResult() {
        return this.obsQuery.getCurrentResult();
    }
    getLastResult() {
        return this.obsQuery.getLastResult();
    }
    getLastError() {
        return this.obsQuery.getLastError();
    }
    resetLastResults() {
        return this.obsQuery.resetLastResults();
    }
    refetch(variables) {
        return this.obsQuery.refetch(variables);
    }
    fetchMore(fetchMoreOptions) {
        return this.obsQuery.fetchMore(fetchMoreOptions);
    }
    subscribeToMore(options) {
        // XXX: there's a bug in apollo-client typings
        // it should not inherit types from ObservableQuery
        return this.obsQuery.subscribeToMore(options);
    }
    updateQuery(mapFn) {
        return this.obsQuery.updateQuery(mapFn);
    }
    stopPolling() {
        return this.obsQuery.stopPolling();
    }
    startPolling(pollInterval) {
        return this.obsQuery.startPolling(pollInterval);
    }
    setOptions(opts) {
        return this.obsQuery.setOptions(opts);
    }
    setVariables(variables) {
        return this.obsQuery.setVariables(variables);
    }
}
//# sourceMappingURL=data:application/json;base64,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