import { ApolloModule } from 'apollo-angular';
import { Inject, InjectionToken, NgModule, Optional } from '@angular/core';
import { ApolloLink, InMemoryCache, } from '@apollo/client/core';
import { ApolloTestingBackend } from './backend';
import { ApolloTestingController } from './controller';
import * as i0 from "@angular/core";
import * as i1 from "apollo-angular";
import * as i2 from "./backend";
import * as i3 from "@apollo/client/core";
export const APOLLO_TESTING_CACHE = new InjectionToken('apollo-angular/testing cache');
export const APOLLO_TESTING_NAMED_CACHE = new InjectionToken('apollo-angular/testing named cache');
export const APOLLO_TESTING_CLIENTS = new InjectionToken('apollo-angular/testing named clients');
function addClient(name, op) {
    op.clientName = name;
    return op;
}
export class ApolloTestingModuleCore {
    constructor(apollo, backend, namedClients, cache, namedCaches) {
        function createOptions(name, c) {
            return {
                connectToDevTools: false,
                link: new ApolloLink(operation => backend.handle(addClient(name, operation))),
                cache: c ||
                    new InMemoryCache({
                        addTypename: false,
                    }),
            };
        }
        apollo.create(createOptions('default', cache));
        if (namedClients && namedClients.length) {
            namedClients.forEach(name => {
                const caches = namedCaches && typeof namedCaches === 'object' ? namedCaches : {};
                apollo.createNamed(name, createOptions(name, caches[name]));
            });
        }
    }
    static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModuleCore, deps: [{ token: i1.Apollo }, { token: i2.ApolloTestingBackend }, { token: APOLLO_TESTING_CLIENTS, optional: true }, { token: APOLLO_TESTING_CACHE, optional: true }, { token: APOLLO_TESTING_NAMED_CACHE, optional: true }], target: i0.ɵɵFactoryTarget.NgModule });
    static ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModuleCore, imports: [ApolloModule] });
    static ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModuleCore, providers: [
            ApolloTestingBackend,
            { provide: ApolloTestingController, useExisting: ApolloTestingBackend },
        ], imports: [ApolloModule] });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModuleCore, decorators: [{
            type: NgModule,
            args: [{
                    imports: [ApolloModule],
                    providers: [
                        ApolloTestingBackend,
                        { provide: ApolloTestingController, useExisting: ApolloTestingBackend },
                    ],
                }]
        }], ctorParameters: () => [{ type: i1.Apollo }, { type: i2.ApolloTestingBackend }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [APOLLO_TESTING_CLIENTS]
                }] }, { type: i3.ApolloCache, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [APOLLO_TESTING_CACHE]
                }] }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [APOLLO_TESTING_NAMED_CACHE]
                }] }] });
export class ApolloTestingModule {
    static withClients(names) {
        return {
            ngModule: ApolloTestingModuleCore,
            providers: [
                {
                    provide: APOLLO_TESTING_CLIENTS,
                    useValue: names,
                },
            ],
        };
    }
    static ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
    static ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModule, imports: [ApolloTestingModuleCore] });
    static ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModule, imports: [ApolloTestingModuleCore] });
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.0.5", ngImport: i0, type: ApolloTestingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [ApolloTestingModuleCore],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kdWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vdGVzdGluZy9zcmMvbW9kdWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBVSxZQUFZLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUN0RCxPQUFPLEVBQUUsTUFBTSxFQUFFLGNBQWMsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNFLE9BQU8sRUFFTCxVQUFVLEVBQ1YsYUFBYSxHQUVkLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLG9CQUFvQixFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ2pELE9BQU8sRUFBRSx1QkFBdUIsRUFBRSxNQUFNLGNBQWMsQ0FBQzs7Ozs7QUFLdkQsTUFBTSxDQUFDLE1BQU0sb0JBQW9CLEdBQUcsSUFBSSxjQUFjLENBQ3BELDhCQUE4QixDQUMvQixDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sMEJBQTBCLEdBQUcsSUFBSSxjQUFjLENBQzFELG9DQUFvQyxDQUNyQyxDQUFDO0FBRUYsTUFBTSxDQUFDLE1BQU0sc0JBQXNCLEdBQUcsSUFBSSxjQUFjLENBQ3RELHNDQUFzQyxDQUN2QyxDQUFDO0FBRUYsU0FBUyxTQUFTLENBQUMsSUFBWSxFQUFFLEVBQWlCO0lBQy9DLEVBQWdCLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztJQUVwQyxPQUFPLEVBQWUsQ0FBQztBQUN6QixDQUFDO0FBU0QsTUFBTSxPQUFPLHVCQUF1QjtJQUNsQyxZQUNFLE1BQWMsRUFDZCxPQUE2QixFQUc3QixZQUF1QixFQUd2QixLQUF3QixFQUd4QixXQUFpQjtRQUVqQixTQUFTLGFBQWEsQ0FBQyxJQUFZLEVBQUUsQ0FBMkI7WUFDOUQsT0FBTztnQkFDTCxpQkFBaUIsRUFBRSxLQUFLO2dCQUN4QixJQUFJLEVBQUUsSUFBSSxVQUFVLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUMsQ0FBQztnQkFDN0UsS0FBSyxFQUNILENBQUM7b0JBQ0QsSUFBSSxhQUFhLENBQUM7d0JBQ2hCLFdBQVcsRUFBRSxLQUFLO3FCQUNuQixDQUFDO2FBQ0wsQ0FBQztRQUNKLENBQUM7UUFFRCxNQUFNLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUUvQyxJQUFJLFlBQVksSUFBSSxZQUFZLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDeEMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTtnQkFDMUIsTUFBTSxNQUFNLEdBQUcsV0FBVyxJQUFJLE9BQU8sV0FBVyxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7Z0JBRWpGLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsQ0FBQyxJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUM5RCxDQUFDLENBQUMsQ0FBQztRQUNMLENBQUM7SUFDSCxDQUFDO3VHQW5DVSx1QkFBdUIsNEVBS3hCLHNCQUFzQiw2QkFHdEIsb0JBQW9CLDZCQUdwQiwwQkFBMEI7d0dBWHpCLHVCQUF1QixZQU54QixZQUFZO3dHQU1YLHVCQUF1QixhQUx2QjtZQUNULG9CQUFvQjtZQUNwQixFQUFFLE9BQU8sRUFBRSx1QkFBdUIsRUFBRSxXQUFXLEVBQUUsb0JBQW9CLEVBQUU7U0FDeEUsWUFKUyxZQUFZOzsyRkFNWCx1QkFBdUI7a0JBUG5DLFFBQVE7bUJBQUM7b0JBQ1IsT0FBTyxFQUFFLENBQUMsWUFBWSxDQUFDO29CQUN2QixTQUFTLEVBQUU7d0JBQ1Qsb0JBQW9CO3dCQUNwQixFQUFFLE9BQU8sRUFBRSx1QkFBdUIsRUFBRSxXQUFXLEVBQUUsb0JBQW9CLEVBQUU7cUJBQ3hFO2lCQUNGOzswQkFLSSxRQUFROzswQkFDUixNQUFNOzJCQUFDLHNCQUFzQjs7MEJBRTdCLFFBQVE7OzBCQUNSLE1BQU07MkJBQUMsb0JBQW9COzswQkFFM0IsUUFBUTs7MEJBQ1IsTUFBTTsyQkFBQywwQkFBMEI7O0FBOEJ0QyxNQUFNLE9BQU8sbUJBQW1CO0lBQzlCLE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBZTtRQUNoQyxPQUFPO1lBQ0wsUUFBUSxFQUFFLHVCQUF1QjtZQUNqQyxTQUFTLEVBQUU7Z0JBQ1Q7b0JBQ0UsT0FBTyxFQUFFLHNCQUFzQjtvQkFDL0IsUUFBUSxFQUFFLEtBQUs7aUJBQ2hCO2FBQ0Y7U0FDRixDQUFDO0lBQ0osQ0FBQzt1R0FYVSxtQkFBbUI7d0dBQW5CLG1CQUFtQixZQXpDbkIsdUJBQXVCO3dHQXlDdkIsbUJBQW1CLFlBRnBCLHVCQUF1Qjs7MkZBRXRCLG1CQUFtQjtrQkFIL0IsUUFBUTttQkFBQztvQkFDUixPQUFPLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztpQkFDbkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcG9sbG8sIEFwb2xsb01vZHVsZSB9IGZyb20gJ2Fwb2xsby1hbmd1bGFyJztcbmltcG9ydCB7IEluamVjdCwgSW5qZWN0aW9uVG9rZW4sIE5nTW9kdWxlLCBPcHRpb25hbCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHtcbiAgQXBvbGxvQ2FjaGUsXG4gIEFwb2xsb0xpbmssXG4gIEluTWVtb3J5Q2FjaGUsXG4gIE9wZXJhdGlvbiBhcyBMaW5rT3BlcmF0aW9uLFxufSBmcm9tICdAYXBvbGxvL2NsaWVudC9jb3JlJztcbmltcG9ydCB7IEFwb2xsb1Rlc3RpbmdCYWNrZW5kIH0gZnJvbSAnLi9iYWNrZW5kJztcbmltcG9ydCB7IEFwb2xsb1Rlc3RpbmdDb250cm9sbGVyIH0gZnJvbSAnLi9jb250cm9sbGVyJztcbmltcG9ydCB7IE9wZXJhdGlvbiB9IGZyb20gJy4vb3BlcmF0aW9uJztcblxuZXhwb3J0IHR5cGUgTmFtZWRDYWNoZXMgPSBSZWNvcmQ8c3RyaW5nLCBBcG9sbG9DYWNoZTxhbnk+IHwgdW5kZWZpbmVkIHwgbnVsbD47XG5cbmV4cG9ydCBjb25zdCBBUE9MTE9fVEVTVElOR19DQUNIRSA9IG5ldyBJbmplY3Rpb25Ub2tlbjxBcG9sbG9DYWNoZTxhbnk+PihcbiAgJ2Fwb2xsby1hbmd1bGFyL3Rlc3RpbmcgY2FjaGUnLFxuKTtcblxuZXhwb3J0IGNvbnN0IEFQT0xMT19URVNUSU5HX05BTUVEX0NBQ0hFID0gbmV3IEluamVjdGlvblRva2VuPE5hbWVkQ2FjaGVzPihcbiAgJ2Fwb2xsby1hbmd1bGFyL3Rlc3RpbmcgbmFtZWQgY2FjaGUnLFxuKTtcblxuZXhwb3J0IGNvbnN0IEFQT0xMT19URVNUSU5HX0NMSUVOVFMgPSBuZXcgSW5qZWN0aW9uVG9rZW48c3RyaW5nW10+KFxuICAnYXBvbGxvLWFuZ3VsYXIvdGVzdGluZyBuYW1lZCBjbGllbnRzJyxcbik7XG5cbmZ1bmN0aW9uIGFkZENsaWVudChuYW1lOiBzdHJpbmcsIG9wOiBMaW5rT3BlcmF0aW9uKTogT3BlcmF0aW9uIHtcbiAgKG9wIGFzIE9wZXJhdGlvbikuY2xpZW50TmFtZSA9IG5hbWU7XG5cbiAgcmV0dXJuIG9wIGFzIE9wZXJhdGlvbjtcbn1cblxuQE5nTW9kdWxlKHtcbiAgaW1wb3J0czogW0Fwb2xsb01vZHVsZV0sXG4gIHByb3ZpZGVyczogW1xuICAgIEFwb2xsb1Rlc3RpbmdCYWNrZW5kLFxuICAgIHsgcHJvdmlkZTogQXBvbGxvVGVzdGluZ0NvbnRyb2xsZXIsIHVzZUV4aXN0aW5nOiBBcG9sbG9UZXN0aW5nQmFja2VuZCB9LFxuICBdLFxufSlcbmV4cG9ydCBjbGFzcyBBcG9sbG9UZXN0aW5nTW9kdWxlQ29yZSB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIGFwb2xsbzogQXBvbGxvLFxuICAgIGJhY2tlbmQ6IEFwb2xsb1Rlc3RpbmdCYWNrZW5kLFxuICAgIEBPcHRpb25hbCgpXG4gICAgQEluamVjdChBUE9MTE9fVEVTVElOR19DTElFTlRTKVxuICAgIG5hbWVkQ2xpZW50cz86IHN0cmluZ1tdLFxuICAgIEBPcHRpb25hbCgpXG4gICAgQEluamVjdChBUE9MTE9fVEVTVElOR19DQUNIRSlcbiAgICBjYWNoZT86IEFwb2xsb0NhY2hlPGFueT4sXG4gICAgQE9wdGlvbmFsKClcbiAgICBASW5qZWN0KEFQT0xMT19URVNUSU5HX05BTUVEX0NBQ0hFKVxuICAgIG5hbWVkQ2FjaGVzPzogYW55LCAvLyBGSVg6IHVzaW5nIE5hbWVkQ2FjaGVzIGhlcmUgbWFrZXMgbmdjIGZhaWxcbiAgKSB7XG4gICAgZnVuY3Rpb24gY3JlYXRlT3B0aW9ucyhuYW1lOiBzdHJpbmcsIGM/OiBBcG9sbG9DYWNoZTxhbnk+IHwgbnVsbCkge1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgY29ubmVjdFRvRGV2VG9vbHM6IGZhbHNlLFxuICAgICAgICBsaW5rOiBuZXcgQXBvbGxvTGluayhvcGVyYXRpb24gPT4gYmFja2VuZC5oYW5kbGUoYWRkQ2xpZW50KG5hbWUsIG9wZXJhdGlvbikpKSxcbiAgICAgICAgY2FjaGU6XG4gICAgICAgICAgYyB8fFxuICAgICAgICAgIG5ldyBJbk1lbW9yeUNhY2hlKHtcbiAgICAgICAgICAgIGFkZFR5cGVuYW1lOiBmYWxzZSxcbiAgICAgICAgICB9KSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgYXBvbGxvLmNyZWF0ZShjcmVhdGVPcHRpb25zKCdkZWZhdWx0JywgY2FjaGUpKTtcblxuICAgIGlmIChuYW1lZENsaWVudHMgJiYgbmFtZWRDbGllbnRzLmxlbmd0aCkge1xuICAgICAgbmFtZWRDbGllbnRzLmZvckVhY2gobmFtZSA9PiB7XG4gICAgICAgIGNvbnN0IGNhY2hlcyA9IG5hbWVkQ2FjaGVzICYmIHR5cGVvZiBuYW1lZENhY2hlcyA9PT0gJ29iamVjdCcgPyBuYW1lZENhY2hlcyA6IHt9O1xuXG4gICAgICAgIGFwb2xsby5jcmVhdGVOYW1lZChuYW1lLCBjcmVhdGVPcHRpb25zKG5hbWUsIGNhY2hlc1tuYW1lXSkpO1xuICAgICAgfSk7XG4gICAgfVxuICB9XG59XG5cbkBOZ01vZHVsZSh7XG4gIGltcG9ydHM6IFtBcG9sbG9UZXN0aW5nTW9kdWxlQ29yZV0sXG59KVxuZXhwb3J0IGNsYXNzIEFwb2xsb1Rlc3RpbmdNb2R1bGUge1xuICBzdGF0aWMgd2l0aENsaWVudHMobmFtZXM6IHN0cmluZ1tdKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG5nTW9kdWxlOiBBcG9sbG9UZXN0aW5nTW9kdWxlQ29yZSxcbiAgICAgIHByb3ZpZGVyczogW1xuICAgICAgICB7XG4gICAgICAgICAgcHJvdmlkZTogQVBPTExPX1RFU1RJTkdfQ0xJRU5UUyxcbiAgICAgICAgICB1c2VWYWx1ZTogbmFtZXMsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==