import { ApolloError } from '@apollo/client/core';
const isApolloError = (err) => err && err.hasOwnProperty('graphQLErrors');
export class TestOperation {
    operation;
    observer;
    constructor(operation, observer) {
        this.operation = operation;
        this.observer = observer;
    }
    flush(result) {
        if (isApolloError(result)) {
            this.observer.error(result);
        }
        else {
            const fetchResult = result ? { ...result } : result;
            this.observer.next(fetchResult);
            this.observer.complete();
        }
    }
    flushData(data) {
        this.flush({
            data,
        });
    }
    networkError(error) {
        const apolloError = new ApolloError({
            networkError: error,
        });
        this.flush(apolloError);
    }
    graphqlErrors(errors) {
        this.flush({
            errors,
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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