import { Observable, observable, queueScheduler } from 'rxjs';
import { map, observeOn, startWith } from 'rxjs/operators';
export function fromPromise(promiseFn) {
    return new Observable(subscriber => {
        promiseFn().then(result => {
            if (!subscriber.closed) {
                subscriber.next(result);
                subscriber.complete();
            }
        }, error => {
            if (!subscriber.closed) {
                subscriber.error(error);
            }
        });
        return () => subscriber.unsubscribe();
    });
}
export function useMutationLoading(source, enabled) {
    if (!enabled) {
        return source.pipe(map(result => ({
            ...result,
            loading: false,
        })));
    }
    return source.pipe(startWith({
        loading: true,
    }), map(result => ({
        ...result,
        loading: !!result.loading,
    })));
}
export class ZoneScheduler {
    zone;
    constructor(zone) {
        this.zone = zone;
    }
    now = Date.now ? Date.now : () => +new Date();
    schedule(work, delay = 0, state) {
        return this.zone.run(() => queueScheduler.schedule(work, delay, state));
    }
}
export function fixObservable(obs) {
    obs[observable] = () => obs;
    return obs;
}
export function wrapWithZone(obs, ngZone) {
    return obs.pipe(observeOn(new ZoneScheduler(ngZone)));
}
//# sourceMappingURL=data:application/json;base64,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