import { HttpClient } from '@angular/common/http';
import { ApolloLink, FetchResult, Observable as LinkObservable, Operation } from '@apollo/client/core';
import { BatchOptions, Context, Options } from './types';
import { prioritize } from './utils';
import * as i0 from "@angular/core";
export declare const defaults: {
    readonly batchInterval: 10;
    readonly batchMax: 10;
    readonly uri: "graphql";
    readonly method: "POST";
    readonly withCredentials: false;
    readonly includeQuery: true;
    readonly includeExtensions: false;
    readonly useMultipart: false;
};
/**
 * Decides which value to pick from Context, Options or defaults
 */
export declare function pick<K extends keyof Omit<typeof defaults, 'batchInterval' | 'batchMax'>>(context: Context, options: Options, key: K): ReturnType<typeof prioritize<Context[K] | Options[K] | (typeof defaults)[K]>>;
export declare class HttpBatchLinkHandler extends ApolloLink {
    private readonly httpClient;
    private readonly options;
    batcher: ApolloLink;
    private batchInterval;
    private batchMax;
    private print;
    constructor(httpClient: HttpClient, options: BatchOptions);
    private createOptions;
    private createBody;
    private createHeaders;
    private createBatchKey;
    request(op: Operation): LinkObservable<FetchResult> | null;
}
export declare class HttpBatchLink {
    private readonly httpClient;
    constructor(httpClient: HttpClient);
    create(options: BatchOptions): HttpBatchLinkHandler;
    static ɵfac: i0.ɵɵFactoryDeclaration<HttpBatchLink, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<HttpBatchLink>;
}
