import { Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpResponse } from '@angular/common/http';
import { ExtractFiles, Request } from './types';
export declare const fetch: (req: Request, httpClient: HttpClient, extractFiles?: ExtractFiles) => Observable<HttpResponse<Object>>;
export declare const mergeHeaders: (source: HttpHeaders | undefined, destination: HttpHeaders) => HttpHeaders;
export declare function prioritize<T>(...values: [NonNullable<T>, ...T[]] | [...T[], NonNullable<T>]): NonNullable<T>;
export declare function createHeadersWithClientAwareness(context: Record<string, any>): HttpHeaders;
