import { Observable } from 'rxjs';
import { NgZone } from '@angular/core';
import type { ApolloError, ApolloQueryResult, FetchMoreQueryOptions, ObservableQuery, OperationVariables, SubscribeToMoreOptions, TypedDocumentNode, UpdateQueryOptions } from '@apollo/client/core';
import { EmptyObject, WatchQueryOptions } from './types';
export type QueryRefFromDocument<T extends TypedDocumentNode> = T extends TypedDocumentNode<infer R, infer V> ? QueryRef<R, V & OperationVariables> : never;
export declare class QueryRef<T, V extends OperationVariables = EmptyObject> {
    private readonly obsQuery;
    valueChanges: Observable<ApolloQueryResult<T>>;
    queryId: ObservableQuery<T, V>['queryId'];
    constructor(obsQuery: ObservableQuery<T, V>, ngZone: NgZone, options: WatchQueryOptions<V, T>);
    get options(): import("@apollo/client/core").WatchQueryOptions<V, T>;
    get variables(): V;
    result(): Promise<ApolloQueryResult<T>>;
    getCurrentResult(): ApolloQueryResult<T>;
    getLastResult(): ApolloQueryResult<T> | undefined;
    getLastError(): ApolloError | undefined;
    resetLastResults(): void;
    refetch(variables?: V): Promise<ApolloQueryResult<T>>;
    fetchMore<K = V>(fetchMoreOptions: FetchMoreQueryOptions<K, T>): Promise<ApolloQueryResult<T>>;
    subscribeToMore<MT = any, MV = EmptyObject>(options: SubscribeToMoreOptions<T, MV, MT>): () => void;
    updateQuery(mapFn: (previousQueryResult: T, options: UpdateQueryOptions<V>) => T): void;
    stopPolling(): void;
    startPolling(pollInterval: number): void;
    setOptions(opts: any): Promise<ApolloQueryResult<T>>;
    setVariables(variables: V): Promise<void | ApolloQueryResult<T>>;
}
