"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runNgAdd = void 0;
const path_1 = require("path");
const testing_1 = require("@angular-devkit/schematics/testing");
const collectionPath = (0, path_1.join)(__dirname, '../collection.json');
async function createTestApp(appOptions = {}) {
    const runner = new testing_1.SchematicTestRunner('apollo-angular', collectionPath);
    const workspaceTree = await runner.runExternalSchematic('@schematics/angular', 'workspace', {
        name: 'workspace',
        version: '11.0.0',
        newProjectRoot: 'projects',
    });
    return runner.runExternalSchematic('@schematics/angular', 'application', {
        ...appOptions,
        name: 'apollo',
    }, workspaceTree);
}
async function runNgAdd(standalone) {
    const projectName = 'apollo';
    const appTree = await createTestApp({ standalone: standalone, name: projectName });
    const runner = new testing_1.SchematicTestRunner('apollo-angular', collectionPath);
    return await runner.runSchematic('ng-add', { project: projectName }, appTree);
}
exports.runNgAdd = runNgAdd;
//# sourceMappingURL=test.js.map