import { ExecutionResult, GraphQLError } from 'graphql';
import { Observer } from 'rxjs';
import { ApolloError, FetchResult, Operation as LinkOperation } from '@apollo/client/core';
export type Operation = LinkOperation & {
    clientName: string;
};
export declare class TestOperation<T = {
    [key: string]: any;
}> {
    readonly operation: Operation;
    private readonly observer;
    constructor(operation: Operation, observer: Observer<FetchResult<T>>);
    flush(result: ExecutionResult | ApolloError): void;
    flushData(data: {
        [key: string]: any;
    } | null): void;
    networkError(error: Error): void;
    graphqlErrors(errors: GraphQLError[]): void;
}
