import type { SchedulerAction, SchedulerLike, Subscription } from 'rxjs';
import { Observable } from 'rxjs';
import { NgZone } from '@angular/core';
import type { Observable as AObservable, ApolloQueryResult, FetchResult, ObservableQuery } from '@apollo/client/core';
import { MutationResult } from './types';
export declare function fromPromise<T>(promiseFn: () => Promise<T>): Observable<T>;
export declare function useMutationLoading<T>(source: Observable<FetchResult<T>>, enabled: boolean): Observable<MutationResult<T>>;
export declare class ZoneScheduler implements SchedulerLike {
    private readonly zone;
    constructor(zone: NgZone);
    now: () => number;
    schedule<T>(work: (this: SchedulerAction<T>, state?: T) => void, delay?: number, state?: T): Subscription;
}
export declare function fixObservable<T>(obs: ObservableQuery<T>): Observable<ApolloQueryResult<T>>;
export declare function fixObservable<T>(obs: AObservable<T>): Observable<T>;
export declare function wrapWithZone<T>(obs: Observable<T>, ngZone: NgZone): Observable<T>;
