"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.purge = void 0;
const fs_1 = __importDefault(require("fs"));
const fileTree_1 = require("./fileTree");
function purge(rootTree, shouldPurge, noHeader, barrelName, logger) {
    // Delete any existing barrels.
    if (shouldPurge) {
        logger.debug(`Purging barrels for ${rootTree}`);
        (0, fileTree_1.walkTree)(rootTree, (directory) => {
            directory.files
                .filter((file) => {
                return file.name === barrelName;
            })
                .filter(file => {
                if (noHeader) {
                    return true;
                }
                return fs_1.default.readFileSync(file.path).includes('@file Automatically generated by barrelsby.');
            })
                .forEach((file) => {
                logger.debug(`Deleting existing barrel @ ${file.path}`);
                // Delete barrel file and clean up tree model.
                fs_1.default.unlinkSync(file.path);
                directory.files.splice(directory.files.indexOf(file), 1);
                directory.barrel = undefined;
            });
        });
    }
}
exports.purge = purge;
//# sourceMappingURL=purge.js.map