/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Provides read-only access to reflection data about symbols. Used internally by Angular
 * to power dependency injection and compilation.
 */
export declare abstract class ReflectorReader {
    abstract parameters(typeOrFunc: any): any[][];
    abstract annotations(typeOrFunc: any): any[];
    abstract propMetadata(typeOrFunc: any): {
        [key: string]: any[];
    };
    abstract importUri(typeOrFunc: any): string | null;
    abstract resourceUri(typeOrFunc: any): string;
    abstract resolveIdentifier(name: string, moduleUrl: string, members: string[], runtime: any): any;
    abstract resolveEnum(identifier: any, name: string): any;
}
