"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Config_1 = __importDefault(require("./Config"));
const DataLoader_1 = __importDefault(require("./DataLoader"));
const MergerError_1 = __importDefault(require("./MergerError"));
const Processor_1 = __importDefault(require("./Processor"));
const FileLoader_1 = __importDefault(require("./fileLoaders/FileLoader"));
const FsFileLoader_1 = __importDefault(require("./fileLoaders/FsFileLoader"));
const DataDeserializer_1 = __importDefault(require("./dataDeserializers/DataDeserializer"));
const JSONDataDeserializer_1 = __importDefault(require("./dataDeserializers/JSONDataDeserializer"));
const YAMLDataDeserializer_1 = __importDefault(require("./dataDeserializers/YAMLDataDeserializer"));
const DataSerializer_1 = __importDefault(require("./dataSerializers/DataSerializer"));
const JSONDataSerializer_1 = __importDefault(require("./dataSerializers/JSONDataSerializer"));
const AfterMergeOperation_1 = __importDefault(require("./operations/AfterMergeOperation"));
const AfterMergesOperation_1 = __importDefault(require("./operations/AfterMergesOperation"));
const AppendOperation_1 = __importDefault(require("./operations/AppendOperation"));
const CombineOperation_1 = __importDefault(require("./operations/CombineOperation"));
const ConcatOperation_1 = __importDefault(require("./operations/ConcatOperation"));
const ExpressionOperation_1 = __importDefault(require("./operations/ExpressionOperation"));
const ImportOperation_1 = __importDefault(require("./operations/ImportOperation"));
const IncludeOperation_1 = __importDefault(require("./operations/IncludeOperation"));
const InsertOperation_1 = __importDefault(require("./operations/InsertOperation"));
const MatchOperation_1 = __importDefault(require("./operations/MatchOperation"));
const MergeOperation_1 = __importDefault(require("./operations/MergeOperation"));
const MoveOperation_1 = __importDefault(require("./operations/MoveOperation"));
const PrependOperation_1 = __importDefault(require("./operations/PrependOperation"));
const RemoveOperation_1 = __importDefault(require("./operations/RemoveOperation"));
const RepeatOperation_1 = __importDefault(require("./operations/RepeatOperation"));
const ReplaceOperation_1 = __importDefault(require("./operations/ReplaceOperation"));
const SelectOperation_1 = __importDefault(require("./operations/SelectOperation"));
class Merger {
    constructor(config) {
        this._config = new Config_1.default(config);
        this._fileLoader = new FileLoader_1.default();
        this._fileLoader.addLoaders([[new FsFileLoader_1.default(), 1]]);
        this._dataDeserializer = new DataDeserializer_1.default();
        this._dataDeserializer.addDeserializers([
            new JSONDataDeserializer_1.default(),
            new YAMLDataDeserializer_1.default(),
        ]);
        this._dataSerializer = new DataSerializer_1.default();
        this._dataSerializer.addSerializers([new JSONDataSerializer_1.default()]);
        this._dataLoader = new DataLoader_1.default(this._config, this._dataDeserializer, this._fileLoader);
        this._processor = new Processor_1.default(this._config, this._dataLoader);
        const operations = [];
        if (this._config.enableExpressionOperation) {
            operations.push(new ExpressionOperation_1.default(this._processor));
        }
        operations.push(new RemoveOperation_1.default(this._processor), new ReplaceOperation_1.default(this._processor), new ImportOperation_1.default(this._processor), new CombineOperation_1.default(this._processor), new ConcatOperation_1.default(this._processor), new AppendOperation_1.default(this._processor), new PrependOperation_1.default(this._processor), new InsertOperation_1.default(this._processor), new SelectOperation_1.default(this._processor), new RepeatOperation_1.default(this._processor), new MatchOperation_1.default(this._processor), new MoveOperation_1.default(this._processor), new MergeOperation_1.default(this._processor), new IncludeOperation_1.default(this._processor), new AfterMergeOperation_1.default(this._processor), new AfterMergesOperation_1.default(this._processor));
        this._processor.addOperations(operations);
    }
    mergeObject(object, config) {
        const sources = [{ type: 0, object }];
        return this._merge(sources, config);
    }
    mergeObjects(objects, config) {
        const sources = objects.map((object) => ({ type: 0, object }));
        return this._merge(sources, config);
    }
    mergeFile(uri, config) {
        const sources = [{ type: 1, uri }];
        return this._merge(sources, config);
    }
    mergeFiles(uris, config) {
        const sources = uris.map((uri) => ({ type: 1, uri }));
        return this._merge(sources, config);
    }
    setConfig(config) {
        this._config.set(config);
    }
    clearCaches() {
        this._dataLoader.clearCache();
    }
    _merge(sources, config) {
        if (config !== undefined) {
            this.setConfig(config);
        }
        let result;
        try {
            result = this._processor.merge(sources);
        }
        catch (e) {
            throw new MergerError_1.default(e, this._processor.currentScope);
        }
        if (this._config.stringify) {
            const pretty = this._config.stringify === "pretty";
            result = this._dataSerializer.serialize(".json", result, pretty, this._config.spaces);
        }
        return result;
    }
}
exports.default = Merger;
//# sourceMappingURL=Merger.js.map