"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Phase = exports.Scope = exports.MergeFileScope = exports.RootMergeFileScope = exports.MergeObjectScope = exports.RootMergeObjectScope = exports.GlobalScope = exports.ScopeBase = void 0;
class ScopeBase {
    constructor(parent, localVariables, phase) {
        this.phase = "merge";
        this.registeredPhases = {};
        this.propertyPath = [];
        this.scopeVariables = {};
        this.localVariables = localVariables;
        if (parent) {
            this.parent = parent;
            this.phase = parent.phase;
            this.scopeVariables = Object.assign({}, this.parent.scopeVariables);
            this.scopeVariables.$parent = this.parent.scopeVariables;
        }
        if (this.localVariables) {
            this.scopeVariables = Object.assign(Object.assign({}, this.scopeVariables), this.localVariables);
        }
        if (phase) {
            this.deregisterPhase(phase);
            this.phase = phase;
        }
    }
    enterProperty(propertyName) {
        if (propertyName !== undefined) {
            this.propertyPath.push(propertyName);
        }
    }
    leaveProperty() {
        this.propertyPath.pop();
    }
    registerPhase(phase) {
        let scope = this;
        while (scope) {
            scope.registeredPhases[phase] = true;
            scope = scope.parent;
        }
    }
    deregisterPhase(phase) {
        let scope = this;
        while (scope) {
            scope.registeredPhases[phase] = false;
            scope = scope.parent;
        }
    }
    hasRegisteredPhase(phase) {
        return this.registeredPhases[phase] === true;
    }
}
exports.ScopeBase = ScopeBase;
class GlobalScope extends ScopeBase {
}
exports.GlobalScope = GlobalScope;
class RootMergeObjectScope extends ScopeBase {
    constructor(source, target, parent, localVariables, phase) {
        super(parent, localVariables, phase);
        this.root = this;
        this.source = source;
        this.target = target;
        this.scopeVariables.$root = this.root.scopeVariables;
        this.scopeVariables.$source = this.source;
        this.scopeVariables.$target = this.target;
    }
}
exports.RootMergeObjectScope = RootMergeObjectScope;
class MergeObjectScope extends ScopeBase {
    constructor(source, target, parent, localVariables, phase) {
        super(parent, localVariables, phase);
        this.root = parent.root;
        this.source = source;
        this.target = target;
        this.scopeVariables.$root = this.root.scopeVariables;
        this.scopeVariables.$source = this.source;
        this.scopeVariables.$target = this.target;
    }
}
exports.MergeObjectScope = MergeObjectScope;
class RootMergeFileScope extends ScopeBase {
    constructor(sourceFilePath, source, target, parent, localVariables, phase) {
        super(parent, localVariables, phase);
        this.root = this;
        this.source = source;
        this.target = target;
        this.sourceFilePath = sourceFilePath;
        this.sourceFileName = this.sourceFilePath
            .replace(/^.*[\\\/:]/, "")
            .replace(/\.[^/.]+$/, "");
        this.scopeVariables.$root = this.root.scopeVariables;
        this.scopeVariables.$source = this.source;
        this.scopeVariables.$target = this.target;
        this.scopeVariables.$sourceFilePath = this.sourceFilePath;
        this.scopeVariables.$sourceFileName = this.sourceFileName;
    }
}
exports.RootMergeFileScope = RootMergeFileScope;
class MergeFileScope extends ScopeBase {
    constructor(sourceFilePath, source, target, parent, localVariables, phase) {
        super(parent, localVariables, phase);
        this.sourceFilePath = sourceFilePath;
        this.source = source;
        this.target = target;
        this.scopeVariables = Object.assign({}, localVariables);
        this.root = this;
        this.sourceFileName = this.sourceFilePath
            .replace(/^.*[\\\/:]/, "")
            .replace(/\.[^/.]+$/, "");
        this.scopeVariables.$root = this.root.scopeVariables;
        this.scopeVariables.$source = this.source;
        this.scopeVariables.$target = this.target;
        this.scopeVariables.$sourceFilePath = this.sourceFilePath;
        this.scopeVariables.$sourceFileName = this.sourceFileName;
    }
}
exports.MergeFileScope = MergeFileScope;
class Scope extends ScopeBase {
    constructor(parent, localVariables, phase) {
        super(parent, localVariables, phase);
        this.root = parent.root;
        this.scopeVariables.$root = this.root.scopeVariables;
    }
}
exports.Scope = Scope;
var Phase;
(function (Phase) {
    Phase["AfterMerge"] = "afterMerge";
    Phase["AfterMerges"] = "afterMerges";
    Phase["Merge"] = "merge";
})(Phase || (exports.Phase = Phase = {}));
//# sourceMappingURL=Scope.js.map