"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const js_yaml_1 = __importDefault(require("js-yaml"));
const yamlFileRegex = /\.ya?ml$/;
class YAMLDataDeserializer {
    match(uri) {
        return yamlFileRegex.test(uri);
    }
    deserialize(uri, content) {
        return js_yaml_1.default.load(content, {
            filename: uri,
            schema: js_yaml_1.default.JSON_SCHEMA,
        });
    }
}
exports.default = YAMLDataDeserializer;
//# sourceMappingURL=YAMLDataDeserializer.js.map