"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jsonFileRegex = /\.json$/;
class JSONDataSerializer {
    match(uri) {
        return jsonFileRegex.test(uri);
    }
    serialize(_, data, pretty, spaces) {
        return JSON.stringify(data, null, this.getIndention(pretty, spaces));
    }
    getIndention(pretty, spaces) {
        if (!pretty) {
            return undefined;
        }
        return spaces !== null && spaces !== void 0 ? spaces : "\t";
    }
}
exports.default = JSONDataSerializer;
//# sourceMappingURL=JSONDataSerializer.js.map