"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const protocolRegex = /^(?:[a-z]+:)?\/\//i;
class FsFileLoader {
    match(uri, currentUri) {
        if (uri.substr(0, 7) === "file://") {
            return true;
        }
        if (protocolRegex.test(uri)) {
            return false;
        }
        if (currentUri.substr(0, 7) === "file://") {
            return true;
        }
        return !protocolRegex.test(currentUri);
    }
    toAbsoluteUri(uri, currentUri) {
        const cwd = path_1.default.dirname(currentUri);
        return path_1.default.resolve(cwd, uri);
    }
    load(uri) {
        return fs_1.default.readFileSync(uri, "utf8");
    }
}
exports.default = FsFileLoader;
//# sourceMappingURL=FsFileLoader.js.map