"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class ConcatOperation extends Operation_1.default {
    name() {
        return "concat";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        const processedSource = this._processor.processSource(keywordValue);
        return [].concat(target, processedSource);
    }
}
exports.default = ConcatOperation;
//# sourceMappingURL=ConcatOperation.js.map