"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const vm_1 = __importDefault(require("vm"));
const Operation_1 = __importDefault(require("./Operation"));
class ExpressionOperation extends Operation_1.default {
    name() {
        return "expression";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        let input;
        let expression;
        if (typeof keywordValue === "string") {
            expression = keywordValue;
        }
        else {
            if (typeof keywordValue.expression === "string") {
                expression = keywordValue.expression;
            }
            if (keywordValue.input !== undefined) {
                input = this._processor.processSourceProperty(keywordValue.input, "input");
            }
        }
        if (!expression) {
            return;
        }
        const sandbox = Object.assign(Object.assign({}, this._processor.currentScope.scopeVariables), { $sourceProperty: keywordValue, $targetProperty: target, $input: input });
        const context = vm_1.default.createContext(sandbox);
        return vm_1.default.runInContext(`eval("${expression}");`, context);
    }
}
exports.default = ExpressionOperation;
//# sourceMappingURL=ExpressionOperation.js.map