"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("../utils/types");
const Operation_1 = __importDefault(require("./Operation"));
class ImportOperation extends Operation_1.default {
    name() {
        return "import";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        const importValues = Array.isArray(keywordValue)
            ? keywordValue
            : [keywordValue];
        const importResult = importValues.reduce((result, importValue) => {
            if (typeof importValue === "string") {
                return this._processor.loadAndProcessFileByRef(importValue, result);
            }
            if (typeof importValue.path !== "string") {
                return result;
            }
            let scopeVariables;
            if ((0, types_1.isObject)(importValue.params)) {
                scopeVariables = {};
                scopeVariables.$params = this._processor.processSourceProperty(importValue.params, "params");
            }
            return this._processor.loadAndProcessFileByRef(importValue.path, result, scopeVariables);
        }, undefined);
        return this._processor.processSource(importResult, target);
    }
}
exports.default = ImportOperation;
//# sourceMappingURL=ImportOperation.js.map