"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsonpath_1 = __importDefault(require("jsonpath"));
const json_ptr_1 = require("json-ptr");
const Operation_1 = __importDefault(require("./Operation"));
class MatchOperation extends Operation_1.default {
    name() {
        return "match";
    }
    processInArray(keyword, source, sourceArray, sourceArrayIndex, resultArray, resultArrayIndex, target) {
        const keywordValue = source[keyword];
        let matchedResultArrayIndex;
        if (keywordValue.index !== undefined) {
            matchedResultArrayIndex =
                keywordValue.index === "-"
                    ? resultArray.length - 1
                    : keywordValue.index;
        }
        else if (keywordValue.query !== undefined) {
            const path = jsonpath_1.default.paths(resultArray, keywordValue.query)[0];
            matchedResultArrayIndex =
                path !== undefined ? path[1] : undefined;
        }
        else if (keywordValue.path !== undefined) {
            if (json_ptr_1.JsonPointer.get(resultArray, keywordValue.path) !== undefined) {
                matchedResultArrayIndex = Number(json_ptr_1.JsonPointer.decode(keywordValue.path)[0]);
            }
        }
        if (matchedResultArrayIndex === undefined ||
            resultArray[matchedResultArrayIndex] === undefined) {
            return { resultArray, resultArrayIndex };
        }
        const result = this._processor.processArrayItem(keywordValue.value, sourceArray, sourceArrayIndex, resultArray, matchedResultArrayIndex, target);
        if (matchedResultArrayIndex <= resultArrayIndex) {
            resultArrayIndex += result.resultArrayIndex - matchedResultArrayIndex;
        }
        return { resultArray: result.resultArray, resultArrayIndex };
    }
}
exports.default = MatchOperation;
//# sourceMappingURL=MatchOperation.js.map