"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Operation_1 = __importDefault(require("./Operation"));
class MergeOperation extends Operation_1.default {
    name() {
        return "merge";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        const processedSourceProperty = this._processor.processSourcePropertyInNewMergeObjectScope(keywordValue.source, "source");
        const processedWithProperty = this._processor.processSourcePropertyInNewMergeObjectScope(keywordValue.with, "with", processedSourceProperty);
        return this._processor.processSource(processedWithProperty, target);
    }
}
exports.default = MergeOperation;
//# sourceMappingURL=MergeOperation.js.map