"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const range = require("lodash.range");
const Operation_1 = __importDefault(require("./Operation"));
const types_1 = require("../utils/types");
class RepeatOperation extends Operation_1.default {
    name() {
        return "repeat";
    }
    processInObject(keyword, source, target) {
        const keywordValue = source[keyword];
        let result;
        let step = 1;
        let values = [];
        if (typeof keywordValue.step === "number") {
            step = keywordValue.step;
        }
        if (typeof keywordValue.from === "number") {
            let from = keywordValue.from;
            let to = from + 1;
            if (typeof keywordValue.to === "number") {
                to = keywordValue.to;
            }
            else if (typeof keywordValue.through === "number") {
                to = keywordValue.through;
                to = to > 0 ? to + 1 : to - 1;
            }
            const normStep = to < from ? -Math.abs(step) : Math.abs(step);
            values = range(from, to, normStep).map((i) => ({ value: i }));
        }
        else if (typeof keywordValue.range === "string") {
            const items = keywordValue.range
                .replace(/,/g, " ")
                .replace(/\s+/g, " ")
                .split(" ");
            items.forEach((item) => {
                const split = item.split(":");
                let itemFrom = Number(split[0]);
                let itemTo = Number(split[1]);
                let itemStep = Number(split[2]);
                if (isNaN(itemFrom)) {
                    return;
                }
                if (isNaN(itemStep)) {
                    itemStep = step;
                }
                if (isNaN(itemTo)) {
                    itemTo = itemFrom;
                }
                itemTo = itemTo > 0 ? itemTo + 1 : itemTo - 1;
                itemStep = itemTo < itemFrom ? -Math.abs(itemStep) : Math.abs(itemStep);
                range(itemFrom, itemTo, itemStep).forEach((i) => values.push({ value: i }));
            });
        }
        else if (keywordValue.in !== undefined) {
            const processedIn = this._processor.processSourceProperty(keywordValue.in, "in");
            if (Array.isArray(processedIn)) {
                values = processedIn.map((value) => ({ value }));
            }
            else if ((0, types_1.isObject)(processedIn)) {
                const obj = processedIn;
                values = Object.keys(obj).map((key) => ({
                    key,
                    value: obj[key],
                }));
            }
        }
        const repeatResult = values.map((value, index) => {
            const scopeVariables = {
                $repeat: {
                    index,
                    key: value.key !== undefined ? value.key : index,
                    value: value.value,
                },
            };
            return this._processor.processSourcePropertyInNewScope(keywordValue.value, "value", undefined, scopeVariables);
        });
        this._processor.disableOperations();
        result = this._processor.processSource(repeatResult, target);
        this._processor.enableOperations();
        return result;
    }
}
exports.default = RepeatOperation;
//# sourceMappingURL=RepeatOperation.js.map