import { animation, style, animate, keyframes, useAnimation, } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const bounce = animation([
    style({ transform: 'translate3d(0, 0, 0)' }),
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({ transform: 'translate3d(0, 0, 0)', offset: 0.2 }),
        style({ transform: 'translate3d(0, -30px, 0)', offset: 0.4 }),
        style({ transform: 'translate3d(0, 0, 0)', offset: 0.53 }),
        style({ transform: 'translate3d(0, -15px, 0)', offset: 0.7 }),
        style({ transform: 'translate3d(0, -4px, 0)', offset: 0.9 }),
        style({ transform: 'translate3d(0, 0, 0)', offset: 1 }),
    ])),
], { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const flash = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ opacity: 1 }),
    style({ opacity: 0 }),
    style({ opacity: 1 }),
    style({ opacity: 0 }),
    style({ opacity: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const pulse = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'scale3d(1, 1, 1)' }),
    style({ transform: 'scale3d({{ scale }}, {{ scale }}, {{ scale }})' }),
    style({ transform: 'scale3d(1, 1, 1)' }),
])), { params: { scale: 1.25, timing: DEFAULT_TIMING, delay: 0 } });
export const rubberBand = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'scale3d(1, 1, 1)', offset: 0 }),
    style({ transform: 'scale3d(1.25, 0.75, 1)', offset: 0.3 }),
    style({ transform: 'scale3d(0.75, 1.25, 1)', offset: 0.4 }),
    style({ transform: 'scale3d(1.15, 0.85, 1)', offset: 0.5 }),
    style({ transform: 'scale3d(.95, 1.05, 1)', offset: 0.65 }),
    style({ transform: 'scale3d(1.05, .95, 1)', offset: 0.75 }),
    style({ transform: 'scale3d(1, 1, 1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const shake = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'translate3d(0, 0, 0)', offset: 0 }),
    style({ transform: 'translate3d({{ translateB }})', offset: 0.1 }),
    style({ transform: 'translate3d({{ translateA }})', offset: 0.2 }),
    style({ transform: 'translate3d({{ translateB }})', offset: 0.3 }),
    style({ transform: 'translate3d({{ translateA }})', offset: 0.4 }),
    style({ transform: 'translate3d({{ translateB }})', offset: 0.5 }),
    style({ transform: 'translate3d({{ translateA }})', offset: 0.6 }),
    style({ transform: 'translate3d({{ translateB }})', offset: 0.7 }),
    style({ transform: 'translate3d({{ translateA }})', offset: 0.8 }),
    style({ transform: 'translate3d({{ translateB }})', offset: 0.9 }),
    style({ transform: 'translate3d(0, 0, 0)', offset: 1 }),
])), {
    params: {
        timing: DEFAULT_TIMING,
        delay: 0,
        translateA: '-10px, 0, 0',
        translateB: '10px, 0, 0',
    },
});
export const shakeX = shake;
export const shakeY = useAnimation(shake, {
    params: { translateA: '0, -10px, 0', translateB: '0, 10px, 0' },
});
export const swing = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'rotate3d(0, 0, 1, 15deg)', offset: 0.2 }),
    style({ transform: 'rotate3d(0, 0, 1, -10deg)', offset: 0.4 }),
    style({ transform: 'rotate3d(0, 0, 1, 5deg)', offset: 0.6 }),
    style({ transform: 'rotate3d(0, 0, 1, -5deg)', offset: 0.8 }),
    style({ transform: 'rotate3d(0, 0, 1, 0deg)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const tada = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'scale3d(1, 1, 1)', offset: 0 }),
    style({
        transform: 'scale3d(.9, .9, .9) rotate3d(0, 0, 1, -3deg)',
        offset: 0.1,
    }),
    style({
        transform: 'scale3d(.9, .9, .9) rotate3d(0, 0, 1, -3deg)',
        offset: 0.2,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, 3deg)',
        offset: 0.3,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, -3deg)',
        offset: 0.4,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, 3deg)',
        offset: 0.5,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, -3deg)',
        offset: 0.6,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, 3deg)',
        offset: 0.7,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, -3deg)',
        offset: 0.8,
    }),
    style({
        transform: 'scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, 3deg)',
        offset: 0.9,
    }),
    style({ transform: 'scale3d(1, 1, 1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const wobble = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'none', offset: 0 }),
    style({
        transform: 'translate3d(-25%, 0, 0) rotate3d(0, 0, 1, -5deg)',
        offset: 0.15,
    }),
    style({
        transform: 'translate3d(20%, 0, 0) rotate3d(0, 0, 1, 3deg)',
        offset: 0.3,
    }),
    style({
        transform: 'translate3d(-15%, 0, 0) rotate3d(0, 0, 1, -3deg)',
        offset: 0.45,
    }),
    style({
        transform: 'translate3d(10%, 0, 0) rotate3d(0, 0, 1, 2deg)',
        offset: 0.6,
    }),
    style({
        transform: 'translate3d(-5%, 0, 0) rotate3d(0, 0, 1, -1deg)',
        offset: 0.75,
    }),
    style({ transform: 'none', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const jello = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'none', offset: 0 }),
    style({ transform: 'none', offset: 0.11 }),
    style({ transform: 'skewX(-12.5deg) skewY(-12.5deg)', offset: 0.22 }),
    style({ transform: 'skewX(6.25deg) skewY(6.25deg)', offset: 0.33 }),
    style({ transform: 'skewX(-3.125deg) skewY(-3.125deg)', offset: 0.44 }),
    style({ transform: 'skewX(1.5625deg) skewY(1.5625deg)', offset: 0.55 }),
    style({
        transform: 'skewX(-0.78125deg) skewY(-0.78125deg)',
        offset: 0.66,
    }),
    style({
        transform: 'skewX(0.390625deg) skewY(0.390625deg)',
        offset: 0.77,
    }),
    style({
        transform: 'skewX(-0.1953125deg) skewY(-0.1953125deg)',
        offset: 0.88,
    }),
    style({ transform: 'none', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const heartBeat = animation(animate('{{ timing }}s {{ delay }}s ease-in-out', keyframes([
    style({ transform: 'scale(1)', offset: 0 }),
    style({ transform: 'scale({{ scale }})', offset: 0.14 }),
    style({ transform: 'scale(1)', offset: 0.28 }),
    style({
        transform: 'scale({{ scale }})',
        offset: 0.42,
    }),
    style({
        transform: 'scale(1)',
        offset: 0.7,
    }),
])), { params: { timing: DEFAULT_TIMING * 1.3, scale: 1.3, delay: 0 } });
export const headShake = animation(animate('{{ timing }}s {{ delay }}s ease-in-out', keyframes([
    style({ transform: 'translateX(0)', offset: 0 }),
    style({ transform: 'translateX(-6px) rotateY(-9deg)', offset: 0.065 }),
    style({ transform: 'translateX(5px) rotateY(7deg)', offset: 0.185 }),
    style({ transform: 'translateX(-3px) rotateY(-5deg)', offset: 0.315 }),
    style({ transform: 'translateX(2px) rotateY(3deg)', offset: 0.435 }),
    style({ transform: 'translateX(0)', offset: 0.5 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
//# sourceMappingURL=data:application/json;base64,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