import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
// https://github.com/animate-css/animate.css/tree/main/source/back_entrances
export const backInUp = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({
        opacity: 0.7,
        transform: 'translateY(1200px) scale(0.7)',
        offset: 0,
    }),
    style({
        opacity: 0.7,
        transform: 'translateY(0px) scale(0.7)',
        offset: 0.8,
    }),
    style({ opacity: 1, transform: 'scale(1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backInDown = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({
        opacity: 0.7,
        transform: 'translateY(-1200px) scale(0.7)',
        offset: 0,
    }),
    style({
        opacity: 0.7,
        transform: 'translateY(0px) scale(0.7)',
        offset: 0.8,
    }),
    style({ opacity: 1, transform: 'scale(1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backInLeft = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({
        opacity: 0.7,
        transform: 'translateX(-2000px) scale(0.7)',
        offset: 0,
    }),
    style({
        opacity: 0.7,
        transform: 'translateX(0px) scale(0.7)',
        offset: 0.8,
    }),
    style({ opacity: 1, transform: 'scale(1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backInRight = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({
        opacity: 0.7,
        transform: 'translateX(2000px) scale(0.7)',
        offset: 0,
    }),
    style({
        opacity: 0.7,
        transform: 'translateX(0px) scale(0.7)',
        offset: 0.8,
    }),
    style({ opacity: 1, transform: 'scale(1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
// https://github.com/animate-css/animate.css/tree/main/source/back_exits
export const backOutUp = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ opacity: 1.0, transform: 'scale(1)' }),
    style({ opacity: 0.7, transform: 'translateY(0px) scale(0.7)' }),
    style({ opacity: 0.7, transform: 'translateY(-700px) scale(0.7)' }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backOutDown = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ opacity: 1.0, transform: 'scale(1)' }),
    style({ opacity: 0.7, transform: 'translateY(0px) scale(0.7)' }),
    style({ opacity: 0.7, transform: 'translateY(700px) scale(0.7)' }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backOutRight = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ opacity: 1.0, transform: 'scale(1)' }),
    style({ opacity: 0.7, transform: 'translateX(0px) scale(0.7)' }),
    style({ opacity: 0.7, transform: 'translateX(2000px) scale(0.7)' }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export const backOutLeft = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ opacity: 1.0, transform: 'scale(1)' }),
    style({ opacity: 0.7, transform: 'translateX(0px) scale(0.7)' }),
    style({ opacity: 0.7, transform: 'translateX(-2000px) scale(0.7)' }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
//# sourceMappingURL=data:application/json;base64,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