import { animation, style, animate, keyframes, } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const bounceIn = animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.215, 0.610, 0.355, 1.000)', keyframes([
    style({ opacity: 0, transform: 'scale3d(.3, .3, .3)', offset: 0 }),
    style({ transform: 'scale3d(1.1, 1.1, 1.1)', offset: 0.2 }),
    style({ transform: 'scale3d(.9, .9, .9)', offset: 0.4 }),
    style({
        opacity: 1,
        transform: 'scale3d(1.03, 1.03, 1.03)',
        offset: 0.6,
    }),
    style({ transform: 'scale3d(.97, .97, .97)', offset: 0.8 }),
    style({ opacity: 1, transform: 'scale3d(1, 1, 1)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0 } });
export function bounceInY(a, b, c, d) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.215, 0.610, 0.355, 1.000)', keyframes([
        style({
            opacity: 0,
            transform: 'translate3d(0, {{ a }}, 0)',
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: 'translate3d(0, {{ b }}, 0)',
            offset: 0.6,
        }),
        style({ transform: 'translate3d(0, {{ c }}, 0)', offset: 0.75 }),
        style({ transform: 'translate3d(0, {{ d }}, 0)', offset: 0.9 }),
        style({ opacity: 1, transform: 'none', offset: 1 }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            a,
            b,
            c,
            d,
        },
    });
}
export function bounceInX(a, b, c, d) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.215, 0.610, 0.355, 1.000)', keyframes([
        style({
            opacity: 0,
            transform: 'translate3d({{ a }}, 0, 0)',
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: 'translate3d({{ b }}, 0, 0)',
            offset: 0.6,
        }),
        style({ transform: 'translate3d({{ c }}, 0, 0)', offset: 0.75 }),
        style({ transform: 'translate3d({{ d }}, 0, 0)', offset: 0.9 }),
        style({ opacity: 1, transform: 'none', offset: 1 }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            a,
            b,
            c,
            d,
        },
    });
}
export const bounceInDown = bounceInY('-3000px', '25px', '-10px', '5px');
export const bounceInUp = bounceInY('3000px', '-25px', '10px', '-5px');
export const bounceInLeft = bounceInX('-3000px', '25px', '-10px', '5px');
export const bounceInRight = bounceInX('3000px', '-25px', '10px', '-5px');
export const bounceOut = animation(animate('{{ timing }}s {{ delay }}s', keyframes([
    style({ transform: 'scale3d(.9, .9, .9)', offset: 0.2 }),
    style({
        opacity: 1,
        transform: 'scale3d({{ scale }}, {{ scale }}, {{ scale }})',
        offset: 0.5,
    }),
    style({
        opacity: 1,
        transform: 'scale3d({{ scale }}, {{ scale }}, {{ scale }})',
        offset: 0.55,
    }),
    style({ opacity: 0, transform: 'scale3d(.3, .3, .3)', offset: 1 }),
])), { params: { timing: DEFAULT_TIMING, delay: 0, scale: 1.1 } });
export function bounceOutY(a, b, c, d) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({ transform: 'translate3d(0, {{ a }}, 0)', offset: 0.2 }),
        style({
            opacity: 1,
            transform: 'translate3d(0, {{ b }}, 0)',
            offset: 0.4,
        }),
        style({
            opacity: 1,
            transform: 'translate3d(0, {{ c }}, 0)',
            offset: 0.45,
        }),
        style({
            opacity: 0,
            transform: 'translate3d(0, {{ d }}, 0)',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            a,
            b,
            c,
            d,
        },
    });
}
export function bounceOutX(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 1,
            transform: 'translate3d({{ a }}, 0, 0)',
            offset: 0.2,
        }),
        style({
            opacity: 0,
            transform: 'translate3d({{ b }}, 0, 0)',
            offset: 1,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export const bounceOutDown = bounceOutY('10px', '-20px', '-20px', '2000px');
export const bounceOutUp = bounceOutY('-10px', '20px', '20px', '-2000px');
export const bounceOutLeft = bounceOutX('20px', '-2000px');
export const bounceOutRight = bounceOutX('-20px', '2000px');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYm91bmNpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9wcm9qZWN0cy9uZy1hbmltYXRlL3NyYy9saWIvYm91bmNpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUNMLFNBQVMsRUFDVCxLQUFLLEVBQ0wsT0FBTyxFQUNQLFNBQVMsR0FFVixNQUFNLHFCQUFxQixDQUFDO0FBQzdCLE9BQU8sRUFBRSxjQUFjLEVBQUUsTUFBTSxTQUFTLENBQUM7QUFFekMsTUFBTSxDQUFDLE1BQU0sUUFBUSxHQUFHLFNBQVMsQ0FDL0IsT0FBTyxDQUNMLHFFQUFxRSxFQUNyRSxTQUFTLENBQUM7SUFDUixLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLFNBQVMsRUFBRSxxQkFBcUIsRUFBRSxNQUFNLEVBQUUsQ0FBQyxFQUFFLENBQUM7SUFDbEUsS0FBSyxDQUFDLEVBQUUsU0FBUyxFQUFFLHdCQUF3QixFQUFFLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQztJQUMzRCxLQUFLLENBQUMsRUFBRSxTQUFTLEVBQUUscUJBQXFCLEVBQUUsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQ3hELEtBQUssQ0FBQztRQUNKLE9BQU8sRUFBRSxDQUFDO1FBQ1YsU0FBUyxFQUFFLDJCQUEyQjtRQUN0QyxNQUFNLEVBQUUsR0FBRztLQUNaLENBQUM7SUFDRixLQUFLLENBQUMsRUFBRSxTQUFTLEVBQUUsd0JBQXdCLEVBQUUsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQzNELEtBQUssQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsU0FBUyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sRUFBRSxDQUFDLEVBQUUsQ0FBQztDQUNoRSxDQUFDLENBQ0gsRUFDRCxFQUFFLE1BQU0sRUFBRSxFQUFFLE1BQU0sRUFBRSxjQUFjLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQ2pELENBQUM7QUFFRixNQUFNLFVBQVUsU0FBUyxDQUN2QixDQUFTLEVBQ1QsQ0FBUyxFQUNULENBQVMsRUFDVCxDQUFTO0lBRVQsT0FBTyxTQUFTLENBQ2QsT0FBTyxDQUNMLHFFQUFxRSxFQUNyRSxTQUFTLENBQUM7UUFDUixLQUFLLENBQUM7WUFDSixPQUFPLEVBQUUsQ0FBQztZQUNWLFNBQVMsRUFBRSw0QkFBNEI7WUFDdkMsTUFBTSxFQUFFLENBQUM7U0FDVixDQUFDO1FBQ0YsS0FBSyxDQUFDO1lBQ0osT0FBTyxFQUFFLENBQUM7WUFDVixTQUFTLEVBQUUsNEJBQTRCO1lBQ3ZDLE1BQU0sRUFBRSxHQUFHO1NBQ1osQ0FBQztRQUNGLEtBQUssQ0FBQyxFQUFFLFNBQVMsRUFBRSw0QkFBNEIsRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFLENBQUM7UUFDaEUsS0FBSyxDQUFDLEVBQUUsU0FBUyxFQUFFLDRCQUE0QixFQUFFLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQztRQUMvRCxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLFNBQVMsRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDO0tBQ3BELENBQUMsQ0FDSCxFQUNEO1FBQ0UsTUFBTSxFQUFFO1lBQ04sTUFBTSxFQUFFLGNBQWM7WUFDdEIsS0FBSyxFQUFFLENBQUM7WUFDUixDQUFDO1lBQ0QsQ0FBQztZQUNELENBQUM7WUFDRCxDQUFDO1NBQ0Y7S0FDRixDQUNGLENBQUM7QUFDSixDQUFDO0FBRUQsTUFBTSxVQUFVLFNBQVMsQ0FDdkIsQ0FBUyxFQUNULENBQVMsRUFDVCxDQUFTLEVBQ1QsQ0FBUztJQUVULE9BQU8sU0FBUyxDQUNkLE9BQU8sQ0FDTCxxRUFBcUUsRUFDckUsU0FBUyxDQUFDO1FBQ1IsS0FBSyxDQUFDO1lBQ0osT0FBTyxFQUFFLENBQUM7WUFDVixTQUFTLEVBQUUsNEJBQTRCO1lBQ3ZDLE1BQU0sRUFBRSxDQUFDO1NBQ1YsQ0FBQztRQUNGLEtBQUssQ0FBQztZQUNKLE9BQU8sRUFBRSxDQUFDO1lBQ1YsU0FBUyxFQUFFLDRCQUE0QjtZQUN2QyxNQUFNLEVBQUUsR0FBRztTQUNaLENBQUM7UUFDRixLQUFLLENBQUMsRUFBRSxTQUFTLEVBQUUsNEJBQTRCLEVBQUUsTUFBTSxFQUFFLElBQUksRUFBRSxDQUFDO1FBQ2hFLEtBQUssQ0FBQyxFQUFFLFNBQVMsRUFBRSw0QkFBNEIsRUFBRSxNQUFNLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDL0QsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsRUFBRSxTQUFTLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxDQUFDLEVBQUUsQ0FBQztLQUNwRCxDQUFDLENBQ0gsRUFDRDtRQUNFLE1BQU0sRUFBRTtZQUNOLE1BQU0sRUFBRSxjQUFjO1lBQ3RCLEtBQUssRUFBRSxDQUFDO1lBQ1IsQ0FBQztZQUNELENBQUM7WUFDRCxDQUFDO1lBQ0QsQ0FBQztTQUNGO0tBQ0YsQ0FDRixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sQ0FBQyxNQUFNLFlBQVksR0FBRyxTQUFTLENBQUMsU0FBUyxFQUFFLE1BQU0sRUFBRSxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFFekUsTUFBTSxDQUFDLE1BQU0sVUFBVSxHQUFHLFNBQVMsQ0FBQyxRQUFRLEVBQUUsT0FBTyxFQUFFLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztBQUV2RSxNQUFNLENBQUMsTUFBTSxZQUFZLEdBQUcsU0FBUyxDQUFDLFNBQVMsRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBRXpFLE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FBRyxTQUFTLENBQUMsUUFBUSxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7QUFFMUUsTUFBTSxDQUFDLE1BQU0sU0FBUyxHQUFHLFNBQVMsQ0FDaEMsT0FBTyxDQUNMLDRCQUE0QixFQUM1QixTQUFTLENBQUM7SUFDUixLQUFLLENBQUMsRUFBRSxTQUFTLEVBQUUscUJBQXFCLEVBQUUsTUFBTSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQ3hELEtBQUssQ0FBQztRQUNKLE9BQU8sRUFBRSxDQUFDO1FBQ1YsU0FBUyxFQUFFLGdEQUFnRDtRQUMzRCxNQUFNLEVBQUUsR0FBRztLQUNaLENBQUM7SUFDRixLQUFLLENBQUM7UUFDSixPQUFPLEVBQUUsQ0FBQztRQUNWLFNBQVMsRUFBRSxnREFBZ0Q7UUFDM0QsTUFBTSxFQUFFLElBQUk7S0FDYixDQUFDO0lBQ0YsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsRUFBRSxTQUFTLEVBQUUscUJBQXFCLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDO0NBQ25FLENBQUMsQ0FDSCxFQUNELEVBQUUsTUFBTSxFQUFFLEVBQUUsTUFBTSxFQUFFLGNBQWMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsRUFBRSxDQUM3RCxDQUFDO0FBRUYsTUFBTSxVQUFVLFVBQVUsQ0FDeEIsQ0FBUyxFQUNULENBQVMsRUFDVCxDQUFTLEVBQ1QsQ0FBUztJQUVULE9BQU8sU0FBUyxDQUNkLE9BQU8sQ0FDTCw0QkFBNEIsRUFDNUIsU0FBUyxDQUFDO1FBQ1IsS0FBSyxDQUFDLEVBQUUsU0FBUyxFQUFFLDRCQUE0QixFQUFFLE1BQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQztRQUMvRCxLQUFLLENBQUM7WUFDSixPQUFPLEVBQUUsQ0FBQztZQUNWLFNBQVMsRUFBRSw0QkFBNEI7WUFDdkMsTUFBTSxFQUFFLEdBQUc7U0FDWixDQUFDO1FBQ0YsS0FBSyxDQUFDO1lBQ0osT0FBTyxFQUFFLENBQUM7WUFDVixTQUFTLEVBQUUsNEJBQTRCO1lBQ3ZDLE1BQU0sRUFBRSxJQUFJO1NBQ2IsQ0FBQztRQUNGLEtBQUssQ0FBQztZQUNKLE9BQU8sRUFBRSxDQUFDO1lBQ1YsU0FBUyxFQUFFLDRCQUE0QjtZQUN2QyxNQUFNLEVBQUUsQ0FBQztTQUNWLENBQUM7S0FDSCxDQUFDLENBQ0gsRUFDRDtRQUNFLE1BQU0sRUFBRTtZQUNOLE1BQU0sRUFBRSxjQUFjO1lBQ3RCLEtBQUssRUFBRSxDQUFDO1lBQ1IsQ0FBQztZQUNELENBQUM7WUFDRCxDQUFDO1lBQ0QsQ0FBQztTQUNGO0tBQ0YsQ0FDRixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sVUFBVSxVQUFVLENBQUMsQ0FBUyxFQUFFLENBQVM7SUFDN0MsT0FBTyxTQUFTLENBQ2QsT0FBTyxDQUNMLDRCQUE0QixFQUM1QixTQUFTLENBQUM7UUFDUixLQUFLLENBQUM7WUFDSixPQUFPLEVBQUUsQ0FBQztZQUNWLFNBQVMsRUFBRSw0QkFBNEI7WUFDdkMsTUFBTSxFQUFFLEdBQUc7U0FDWixDQUFDO1FBQ0YsS0FBSyxDQUFDO1lBQ0osT0FBTyxFQUFFLENBQUM7WUFDVixTQUFTLEVBQUUsNEJBQTRCO1lBQ3ZDLE1BQU0sRUFBRSxDQUFDO1NBQ1YsQ0FBQztLQUNILENBQUMsQ0FDSCxFQUNELEVBQUUsTUFBTSxFQUFFLEVBQUUsTUFBTSxFQUFFLGNBQWMsRUFBRSxLQUFLLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUN2RCxDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sQ0FBQyxNQUFNLGFBQWEsR0FBRyxVQUFVLENBQUMsTUFBTSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsUUFBUSxDQUFDLENBQUM7QUFFNUUsTUFBTSxDQUFDLE1BQU0sV0FBVyxHQUFHLFVBQVUsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxTQUFTLENBQUMsQ0FBQztBQUUxRSxNQUFNLENBQUMsTUFBTSxhQUFhLEdBQUcsVUFBVSxDQUFDLE1BQU0sRUFBRSxTQUFTLENBQUMsQ0FBQztBQUUzRCxNQUFNLENBQUMsTUFBTSxjQUFjLEdBQUcsVUFBVSxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIGFuaW1hdGlvbixcbiAgc3R5bGUsXG4gIGFuaW1hdGUsXG4gIGtleWZyYW1lcyxcbiAgQW5pbWF0aW9uUmVmZXJlbmNlTWV0YWRhdGEsXG59IGZyb20gJ0Bhbmd1bGFyL2FuaW1hdGlvbnMnO1xuaW1wb3J0IHsgREVGQVVMVF9USU1JTkcgfSBmcm9tICcuL3V0aWxzJztcblxuZXhwb3J0IGNvbnN0IGJvdW5jZUluID0gYW5pbWF0aW9uKFxuICBhbmltYXRlKFxuICAgICd7eyB0aW1pbmcgfX1zIHt7IGRlbGF5IH19cyBjdWJpYy1iZXppZXIoMC4yMTUsIDAuNjEwLCAwLjM1NSwgMS4wMDApJyxcbiAgICBrZXlmcmFtZXMoW1xuICAgICAgc3R5bGUoeyBvcGFjaXR5OiAwLCB0cmFuc2Zvcm06ICdzY2FsZTNkKC4zLCAuMywgLjMpJywgb2Zmc2V0OiAwIH0pLFxuICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICdzY2FsZTNkKDEuMSwgMS4xLCAxLjEpJywgb2Zmc2V0OiAwLjIgfSksXG4gICAgICBzdHlsZSh7IHRyYW5zZm9ybTogJ3NjYWxlM2QoLjksIC45LCAuOSknLCBvZmZzZXQ6IDAuNCB9KSxcbiAgICAgIHN0eWxlKHtcbiAgICAgICAgb3BhY2l0eTogMSxcbiAgICAgICAgdHJhbnNmb3JtOiAnc2NhbGUzZCgxLjAzLCAxLjAzLCAxLjAzKScsXG4gICAgICAgIG9mZnNldDogMC42LFxuICAgICAgfSksXG4gICAgICBzdHlsZSh7IHRyYW5zZm9ybTogJ3NjYWxlM2QoLjk3LCAuOTcsIC45NyknLCBvZmZzZXQ6IDAuOCB9KSxcbiAgICAgIHN0eWxlKHsgb3BhY2l0eTogMSwgdHJhbnNmb3JtOiAnc2NhbGUzZCgxLCAxLCAxKScsIG9mZnNldDogMSB9KSxcbiAgICBdKVxuICApLFxuICB7IHBhcmFtczogeyB0aW1pbmc6IERFRkFVTFRfVElNSU5HLCBkZWxheTogMCB9IH1cbik7XG5cbmV4cG9ydCBmdW5jdGlvbiBib3VuY2VJblkoXG4gIGE6IHN0cmluZyxcbiAgYjogc3RyaW5nLFxuICBjOiBzdHJpbmcsXG4gIGQ6IHN0cmluZ1xuKTogQW5pbWF0aW9uUmVmZXJlbmNlTWV0YWRhdGEge1xuICByZXR1cm4gYW5pbWF0aW9uKFxuICAgIGFuaW1hdGUoXG4gICAgICAne3sgdGltaW5nIH19cyB7eyBkZWxheSB9fXMgY3ViaWMtYmV6aWVyKDAuMjE1LCAwLjYxMCwgMC4zNTUsIDEuMDAwKScsXG4gICAgICBrZXlmcmFtZXMoW1xuICAgICAgICBzdHlsZSh7XG4gICAgICAgICAgb3BhY2l0eTogMCxcbiAgICAgICAgICB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBhIH19LCAwKScsXG4gICAgICAgICAgb2Zmc2V0OiAwLFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoe1xuICAgICAgICAgIG9wYWNpdHk6IDEsXG4gICAgICAgICAgdHJhbnNmb3JtOiAndHJhbnNsYXRlM2QoMCwge3sgYiB9fSwgMCknLFxuICAgICAgICAgIG9mZnNldDogMC42LFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBjIH19LCAwKScsIG9mZnNldDogMC43NSB9KSxcbiAgICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBkIH19LCAwKScsIG9mZnNldDogMC45IH0pLFxuICAgICAgICBzdHlsZSh7IG9wYWNpdHk6IDEsIHRyYW5zZm9ybTogJ25vbmUnLCBvZmZzZXQ6IDEgfSksXG4gICAgICBdKVxuICAgICksXG4gICAge1xuICAgICAgcGFyYW1zOiB7XG4gICAgICAgIHRpbWluZzogREVGQVVMVF9USU1JTkcsXG4gICAgICAgIGRlbGF5OiAwLFxuICAgICAgICBhLFxuICAgICAgICBiLFxuICAgICAgICBjLFxuICAgICAgICBkLFxuICAgICAgfSxcbiAgICB9XG4gICk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBib3VuY2VJblgoXG4gIGE6IHN0cmluZyxcbiAgYjogc3RyaW5nLFxuICBjOiBzdHJpbmcsXG4gIGQ6IHN0cmluZ1xuKTogQW5pbWF0aW9uUmVmZXJlbmNlTWV0YWRhdGEge1xuICByZXR1cm4gYW5pbWF0aW9uKFxuICAgIGFuaW1hdGUoXG4gICAgICAne3sgdGltaW5nIH19cyB7eyBkZWxheSB9fXMgY3ViaWMtYmV6aWVyKDAuMjE1LCAwLjYxMCwgMC4zNTUsIDEuMDAwKScsXG4gICAgICBrZXlmcmFtZXMoW1xuICAgICAgICBzdHlsZSh7XG4gICAgICAgICAgb3BhY2l0eTogMCxcbiAgICAgICAgICB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCh7eyBhIH19LCAwLCAwKScsXG4gICAgICAgICAgb2Zmc2V0OiAwLFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoe1xuICAgICAgICAgIG9wYWNpdHk6IDEsXG4gICAgICAgICAgdHJhbnNmb3JtOiAndHJhbnNsYXRlM2Qoe3sgYiB9fSwgMCwgMCknLFxuICAgICAgICAgIG9mZnNldDogMC42LFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCh7eyBjIH19LCAwLCAwKScsIG9mZnNldDogMC43NSB9KSxcbiAgICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCh7eyBkIH19LCAwLCAwKScsIG9mZnNldDogMC45IH0pLFxuICAgICAgICBzdHlsZSh7IG9wYWNpdHk6IDEsIHRyYW5zZm9ybTogJ25vbmUnLCBvZmZzZXQ6IDEgfSksXG4gICAgICBdKVxuICAgICksXG4gICAge1xuICAgICAgcGFyYW1zOiB7XG4gICAgICAgIHRpbWluZzogREVGQVVMVF9USU1JTkcsXG4gICAgICAgIGRlbGF5OiAwLFxuICAgICAgICBhLFxuICAgICAgICBiLFxuICAgICAgICBjLFxuICAgICAgICBkLFxuICAgICAgfSxcbiAgICB9XG4gICk7XG59XG5cbmV4cG9ydCBjb25zdCBib3VuY2VJbkRvd24gPSBib3VuY2VJblkoJy0zMDAwcHgnLCAnMjVweCcsICctMTBweCcsICc1cHgnKTtcblxuZXhwb3J0IGNvbnN0IGJvdW5jZUluVXAgPSBib3VuY2VJblkoJzMwMDBweCcsICctMjVweCcsICcxMHB4JywgJy01cHgnKTtcblxuZXhwb3J0IGNvbnN0IGJvdW5jZUluTGVmdCA9IGJvdW5jZUluWCgnLTMwMDBweCcsICcyNXB4JywgJy0xMHB4JywgJzVweCcpO1xuXG5leHBvcnQgY29uc3QgYm91bmNlSW5SaWdodCA9IGJvdW5jZUluWCgnMzAwMHB4JywgJy0yNXB4JywgJzEwcHgnLCAnLTVweCcpO1xuXG5leHBvcnQgY29uc3QgYm91bmNlT3V0ID0gYW5pbWF0aW9uKFxuICBhbmltYXRlKFxuICAgICd7eyB0aW1pbmcgfX1zIHt7IGRlbGF5IH19cycsXG4gICAga2V5ZnJhbWVzKFtcbiAgICAgIHN0eWxlKHsgdHJhbnNmb3JtOiAnc2NhbGUzZCguOSwgLjksIC45KScsIG9mZnNldDogMC4yIH0pLFxuICAgICAgc3R5bGUoe1xuICAgICAgICBvcGFjaXR5OiAxLFxuICAgICAgICB0cmFuc2Zvcm06ICdzY2FsZTNkKHt7IHNjYWxlIH19LCB7eyBzY2FsZSB9fSwge3sgc2NhbGUgfX0pJyxcbiAgICAgICAgb2Zmc2V0OiAwLjUsXG4gICAgICB9KSxcbiAgICAgIHN0eWxlKHtcbiAgICAgICAgb3BhY2l0eTogMSxcbiAgICAgICAgdHJhbnNmb3JtOiAnc2NhbGUzZCh7eyBzY2FsZSB9fSwge3sgc2NhbGUgfX0sIHt7IHNjYWxlIH19KScsXG4gICAgICAgIG9mZnNldDogMC41NSxcbiAgICAgIH0pLFxuICAgICAgc3R5bGUoeyBvcGFjaXR5OiAwLCB0cmFuc2Zvcm06ICdzY2FsZTNkKC4zLCAuMywgLjMpJywgb2Zmc2V0OiAxIH0pLFxuICAgIF0pXG4gICksXG4gIHsgcGFyYW1zOiB7IHRpbWluZzogREVGQVVMVF9USU1JTkcsIGRlbGF5OiAwLCBzY2FsZTogMS4xIH0gfVxuKTtcblxuZXhwb3J0IGZ1bmN0aW9uIGJvdW5jZU91dFkoXG4gIGE6IHN0cmluZyxcbiAgYjogc3RyaW5nLFxuICBjOiBzdHJpbmcsXG4gIGQ6IHN0cmluZ1xuKTogQW5pbWF0aW9uUmVmZXJlbmNlTWV0YWRhdGEge1xuICByZXR1cm4gYW5pbWF0aW9uKFxuICAgIGFuaW1hdGUoXG4gICAgICAne3sgdGltaW5nIH19cyB7eyBkZWxheSB9fXMnLFxuICAgICAga2V5ZnJhbWVzKFtcbiAgICAgICAgc3R5bGUoeyB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBhIH19LCAwKScsIG9mZnNldDogMC4yIH0pLFxuICAgICAgICBzdHlsZSh7XG4gICAgICAgICAgb3BhY2l0eTogMSxcbiAgICAgICAgICB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBiIH19LCAwKScsXG4gICAgICAgICAgb2Zmc2V0OiAwLjQsXG4gICAgICAgIH0pLFxuICAgICAgICBzdHlsZSh7XG4gICAgICAgICAgb3BhY2l0eTogMSxcbiAgICAgICAgICB0cmFuc2Zvcm06ICd0cmFuc2xhdGUzZCgwLCB7eyBjIH19LCAwKScsXG4gICAgICAgICAgb2Zmc2V0OiAwLjQ1LFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoe1xuICAgICAgICAgIG9wYWNpdHk6IDAsXG4gICAgICAgICAgdHJhbnNmb3JtOiAndHJhbnNsYXRlM2QoMCwge3sgZCB9fSwgMCknLFxuICAgICAgICAgIG9mZnNldDogMSxcbiAgICAgICAgfSksXG4gICAgICBdKVxuICAgICksXG4gICAge1xuICAgICAgcGFyYW1zOiB7XG4gICAgICAgIHRpbWluZzogREVGQVVMVF9USU1JTkcsXG4gICAgICAgIGRlbGF5OiAwLFxuICAgICAgICBhLFxuICAgICAgICBiLFxuICAgICAgICBjLFxuICAgICAgICBkLFxuICAgICAgfSxcbiAgICB9XG4gICk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBib3VuY2VPdXRYKGE6IHN0cmluZywgYjogc3RyaW5nKTogQW5pbWF0aW9uUmVmZXJlbmNlTWV0YWRhdGEge1xuICByZXR1cm4gYW5pbWF0aW9uKFxuICAgIGFuaW1hdGUoXG4gICAgICAne3sgdGltaW5nIH19cyB7eyBkZWxheSB9fXMnLFxuICAgICAga2V5ZnJhbWVzKFtcbiAgICAgICAgc3R5bGUoe1xuICAgICAgICAgIG9wYWNpdHk6IDEsXG4gICAgICAgICAgdHJhbnNmb3JtOiAndHJhbnNsYXRlM2Qoe3sgYSB9fSwgMCwgMCknLFxuICAgICAgICAgIG9mZnNldDogMC4yLFxuICAgICAgICB9KSxcbiAgICAgICAgc3R5bGUoe1xuICAgICAgICAgIG9wYWNpdHk6IDAsXG4gICAgICAgICAgdHJhbnNmb3JtOiAndHJhbnNsYXRlM2Qoe3sgYiB9fSwgMCwgMCknLFxuICAgICAgICAgIG9mZnNldDogMSxcbiAgICAgICAgfSksXG4gICAgICBdKVxuICAgICksXG4gICAgeyBwYXJhbXM6IHsgdGltaW5nOiBERUZBVUxUX1RJTUlORywgZGVsYXk6IDAsIGEsIGIgfSB9XG4gICk7XG59XG5cbmV4cG9ydCBjb25zdCBib3VuY2VPdXREb3duID0gYm91bmNlT3V0WSgnMTBweCcsICctMjBweCcsICctMjBweCcsICcyMDAwcHgnKTtcblxuZXhwb3J0IGNvbnN0IGJvdW5jZU91dFVwID0gYm91bmNlT3V0WSgnLTEwcHgnLCAnMjBweCcsICcyMHB4JywgJy0yMDAwcHgnKTtcblxuZXhwb3J0IGNvbnN0IGJvdW5jZU91dExlZnQgPSBib3VuY2VPdXRYKCcyMHB4JywgJy0yMDAwcHgnKTtcblxuZXhwb3J0IGNvbnN0IGJvdW5jZU91dFJpZ2h0ID0gYm91bmNlT3V0WCgnLTIwcHgnLCAnMjAwMHB4Jyk7XG4iXX0=