import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export function fadeXY(fromX, fromY, toX, toY, fromOpacity = 0, toOpacity = 1) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: '{{ fromOpacity }}',
            transform: 'translate3d({{ fromX }}, {{ fromY }}, 0)',
            offset: 0,
        }),
        style({
            opacity: '{{ toOpacity }}',
            transform: 'translate3d({{ toX }}, {{ toY }}, 0)',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            fromX,
            toX,
            fromY,
            toY,
            fromOpacity,
            toOpacity,
        },
    });
}
export function fadeInX(a, b, fromOpacity = 0, toOpacity = 1) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: '{{ fromOpacity }}',
            transform: 'translate3d({{ a }}, 0, 0)',
            offset: 0,
        }),
        style({
            opacity: '{{ toOpacity }}',
            transform: 'translate3d({{ b }}, 0, 0)',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            a,
            b,
            fromOpacity,
            toOpacity,
        },
    });
}
export function fadeInY(a, b, fromOpacity = 0, toOpacity = 1) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: '{{ fromOpacity }}',
            transform: 'translate3d(0, {{ a }}, 0)',
            offset: 0,
        }),
        style({
            opacity: '{{ toOpacity }}',
            transform: 'translate3d(0, {{ b }}, 0)',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            a,
            b,
            fromOpacity,
            toOpacity,
        },
    });
}
export const fadeIn = fadeInX(0, 0);
export const fadeInDown = fadeInY('-100%', 0);
export const fadeInDownBig = fadeInY('-2000px', 0);
export const fadeInUp = fadeInY('100%', 0);
export const fadeInUpBig = fadeInY('2000px', 0);
export const fadeInLeft = fadeInX('-100%', 0);
export const fadeInLeftBig = fadeInX('-2000px', 0);
export const fadeInRight = fadeInX('100%', 0);
export const fadeInRightBig = fadeInX('2000px', 0);
export const fadeInTopLeft = fadeXY('-100%', '-100%', 0, 0);
export const fadeInTopRight = fadeXY('100%', '-100%', 0, 0);
export const fadeInBottomLeft = fadeXY('-100%', '100%', 0, 0);
export const fadeInBottomRight = fadeXY('100%', '100%', 0, 0);
export function fadeOutX(a, b) {
    return fadeInX(a, b, 1, 0);
}
export function fadeOutY(a, b) {
    return fadeInY(a, b, 1, 0);
}
export const fadeOut = fadeOutX(0, 0);
export const fadeOutDown = fadeOutY(0, '100%');
export const fadeOutDownBig = fadeOutY(0, '2000px');
export const fadeOutUp = fadeOutY(0, '-100%');
export const fadeOutUpBig = fadeOutY(0, '-2000px');
export const fadeOutLeft = fadeOutX(0, '-100%');
export const fadeOutLeftBig = fadeOutX(0, '-2000px');
export const fadeOutRight = fadeOutX(0, '100%');
export const fadeOutRightBig = fadeOutX(0, '2000px');
export const fadeOutTopLeft = fadeXY(0, 0, '-100%', '-100%', 1, 0);
export const fadeOutTopRight = fadeXY(0, 0, '100%', '-100%', 1, 0);
export const fadeOutBottomLeft = fadeXY(0, 0, '-100%', '100%', 1, 0);
export const fadeOutBottomRight = fadeXY(0, 0, '100%', '100%', 1, 0);
export function slideX(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            transform: 'translate3d({{ a }}, 0, 0)',
            offset: 0,
        }),
        style({
            transform: 'translate3d({{ b }}, 0, 0)',
            offset: 1,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export function slideY(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            transform: 'translate3d(0, {{ a }}, 0)',
            offset: 0,
        }),
        style({
            transform: 'translate3d(0, {{ b }}, 0)',
            offset: 1,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export const slideInUp = slideY('-100%', 0);
export const slideInDown = slideY('100%', 0);
export const slideInLeft = slideX('-100%', 0);
export const slideInRight = slideX('100%', 0);
export const slideOutUp = slideY(0, '-100%');
export const slideOutDown = slideY(0, '100%');
export const slideOutLeft = slideX(0, '-100%');
export const slideOutRight = slideX(0, '100%');
//# sourceMappingURL=data:application/json;base64,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