import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const flip = animation([
    style({ 'backface-visibility': 'visible' }),
    animate('{{ timing }}s {{ delay }}s ease-out', keyframes([
        style({
            transform: 'perspective(400px) rotate3d(0, 1, 0, -360deg)',
            offset: 0,
        }),
        style({
            transform: 'perspective(400px) scale3d(1.5, 1.5, 1.5) rotate3d(0, 1, 0, -190deg)',
            offset: 0.4,
        }),
        style({
            transform: 'perspective(400px) scale3d(1.5, 1.5, 1.5) rotate3d(0, 1, 0, -170deg)',
            offset: 0.5,
        }),
        style({
            transform: 'perspective(400px) scale3d(.95, .95, .95)',
            offset: 0.8,
        }),
        style({
            transform: 'perspective(400px)',
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export function flipIn(rotateX, rotateY) {
    return animation([
        style({ 'backface-visibility': 'visible' }),
        animate('{{ timing }}s {{ delay }}s ease-in', keyframes([
            style({
                opacity: 0,
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, 90deg)',
                offset: 0,
            }),
            style({
                opacity: 1,
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, -20deg)',
                offset: 0.4,
            }),
            style({
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, 10deg)',
                offset: 0.6,
            }),
            style({
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, -5deg)',
                offset: 0.8,
            }),
            style({
                transform: 'perspective(400px) rotate3d(0, 0, 0, 0)',
                offset: 1,
            }),
        ])),
    ], { params: { timing: DEFAULT_TIMING, delay: 0, rotateX, rotateY } });
}
export const flipInX = flipIn(1, 0);
export const flipInY = flipIn(0, 1);
export function flipOut(rotateX, rotateY) {
    return animation([
        style({ 'backface-visibility': 'visible' }),
        animate('{{ timing }}s {{ delay }}s', keyframes([
            style({
                transform: 'perspective(400px)',
                offset: 0,
            }),
            style({
                opacity: 1,
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, -20deg)',
                offset: 0.3,
            }),
            style({
                opacity: 0,
                transform: 'perspective(400px) rotate3d({{ rotateX }}, {{ rotateY }}, 0, 90deg)',
                offset: 1,
            }),
        ])),
    ], { params: { timing: DEFAULT_TIMING, delay: 0, rotateX, rotateY } });
}
export const flipOutX = flipOut(1, 0);
export const flipOutY = flipOut(0, 1);
//# sourceMappingURL=data:application/json;base64,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