import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const lightSpeedInLeft = animation(animate('{{ timing }}s {{ delay }}s ease-out', keyframes([
    style({
        transform: 'translate3d(-100%, 0, 0) skewX(30deg)',
        opacity: 0,
        offset: 0,
    }),
    style({
        transform: 'skewX(-20deg)',
        opacity: 1,
        offset: 0.6,
    }),
    style({
        transform: 'skewX(5deg)',
        offset: 0.8,
    }),
    style({
        transform: 'translate3d(0, 0, 0)',
        offset: 1,
    }),
])), {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const lightSpeedIn = animation(animate('{{ timing }}s {{ delay }}s ease-out', keyframes([
    style({
        transform: 'translate3d(100%, 0, 0) skewX(-30deg)',
        opacity: 0,
        offset: 0,
    }),
    style({
        transform: 'skewX(20deg)',
        opacity: 1,
        offset: 0.6,
    }),
    style({
        transform: 'skewX(-5deg)',
        offset: 0.8,
    }),
    style({
        transform: 'translate3d(0, 0, 0)',
        offset: 1,
    }),
])), {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const lightSpeedInRight = lightSpeedIn;
export const lightSpeedOut = animation(animate('{{ timing }}s {{ delay }}s ease-in', keyframes([
    style({
        opacity: 1,
        offset: 0,
    }),
    style({
        opacity: 0,
        transform: 'translate3d(100%, 0, 0) skewX(30deg)',
        offset: 1,
    }),
])), {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const lightSpeedOutRight = lightSpeedOut;
export const lightSpeedOutLeft = animation(animate('{{ timing }}s {{ delay }}s ease-in', keyframes([
    style({
        opacity: 1,
        offset: 0,
    }),
    style({
        opacity: 0,
        transform: 'translate3d(-100%, 0, 0) skewX(-30deg)',
        offset: 1,
    }),
])), {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
//# sourceMappingURL=data:application/json;base64,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