import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export function rotateInDirection(origin, degrees) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            'transform-origin': '{{ origin }}',
            opacity: '{{ fromOpacity }}',
            transform: 'rotate3d(0, 0, 1, {{ degrees }})',
            offset: 0,
        }),
        style({
            'transform-origin': '{{ origin }}',
            opacity: '{{ toOpacity }}',
            transform: 'none',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            origin,
            degrees,
            fromOpacity: 0,
            toOpacity: 1,
        },
    });
}
export function rotateOutDirection(origin, degrees) {
    return animation(animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            'transform-origin': '{{ origin }}',
            opacity: '{{ fromOpacity }}',
            transform: 'none',
            offset: 0,
        }),
        style({
            'transform-origin': '{{ origin }}',
            opacity: '{{ toOpacity }}',
            transform: 'rotate3d(0, 0, 1, {{ degrees }})',
            offset: 1,
        }),
    ])), {
        params: {
            timing: DEFAULT_TIMING,
            delay: 0,
            origin,
            degrees,
            fromOpacity: 1,
            toOpacity: 0,
        },
    });
}
export const rotateIn = rotateInDirection('center', '-200deg');
export const rotateInDownLeft = rotateInDirection('left bottom', '-45deg');
export const rotateInDownRight = rotateInDirection('right bottom', '45deg');
export const rotateInUpLeft = rotateInDirection('left bottom', '45deg');
export const rotateInUpRight = rotateInDirection('right bottom', '-90deg');
export const rotateOut = rotateOutDirection('center', '200deg');
export const rotateOutDownLeft = rotateOutDirection('left bottom', '45deg');
export const rotateOutDownRight = rotateOutDirection('right bottom', '-45deg');
export const rotateOutUpLeft = rotateOutDirection('left bottom', '-45deg');
export const rotateOutUpRight = rotateOutDirection('right bottom', '90deg');
//# sourceMappingURL=data:application/json;base64,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