import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const hinge = animation([
    style({ 'transform-origin': 'top left' }),
    animate('{{ timing }}s {{ delay }}s ease-in-out', keyframes([
        style({
            transform: 'rotate3d(0, 0, 1, 80deg)',
            offset: 0.2,
        }),
        style({
            transform: 'rotate3d(0, 0, 1, 60deg)',
            offset: 0.4,
        }),
        style({
            transform: 'rotate3d(0, 0, 1, 80deg)',
            offset: 0.6,
        }),
        style({
            opacity: 1,
            transform: 'rotate3d(0, 0, 1, 60deg)',
            offset: 0.8,
        }),
        style({
            opacity: 0,
            transform: 'translate3d(0, 700px, 0)',
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const jackInTheBox = animation([
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 0,
            transform: 'scale(0.1) rotate(30deg)',
            'transform-origin': 'center bottom',
            offset: 0,
        }),
        style({
            opacity: 0.5,
            transform: 'rotate(-10deg)',
            offset: 0.5,
        }),
        style({
            opacity: 0.7,
            transform: 'rotate(3deg)',
            offset: 0.7,
        }),
        style({
            opacity: 1,
            transform: 'scale(1)',
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const rollIn = animation([
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 0,
            transform: 'translate3d(-100%, 0, 0) rotate3d(0, 0, 1, -120deg)',
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: 'none',
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export const rollOut = animation([
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 1,
            offset: 0,
        }),
        style({
            opacity: 0,
            transform: 'translate3d(100%, 0, 0) rotate3d(0, 0, 1, 120deg)',
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
//# sourceMappingURL=data:application/json;base64,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