import { animate, animation, keyframes, style } from '@angular/animations';
import { DEFAULT_TIMING } from './utils';
export const zoomIn = animation([
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 0,
            transform: 'scale3d(.3, .3, .3)',
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: 'scale3d(1, 1, 1)',
            offset: 0.5,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export function zoomInY(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.550, 0.055, 0.675, 0.190)', keyframes([
        style({
            opacity: 0,
            transform: `scale3d(.1, .1, .1) translate3d(0, {{ a }}, 0)`,
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: `scale3d(.475, .475, .475) translate3d(0, {{ b }}, 0)`,
            offset: 0.6,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export function zoomInX(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.550, 0.055, 0.675, 0.190)', keyframes([
        style({
            opacity: 0,
            transform: `scale3d(.1, .1, .1) translate3d({{ a }}, 0, 0)`,
            offset: 0,
        }),
        style({
            opacity: 1,
            transform: `scale3d(.475, .475, .475) translate3d({{ b }}, 0, 0)`,
            offset: 0.6,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export const zoomInDown = zoomInY('-1000px', '10px');
export const zoomInUp = zoomInY('1000px', '-10px');
export const zoomInLeft = zoomInX('-1000px', '10px');
export const zoomInRight = zoomInX('1000px', '-10px');
export const zoomOut = animation([
    animate('{{ timing }}s {{ delay }}s', keyframes([
        style({
            opacity: 1,
            offset: 0,
        }),
        style({
            opacity: 0,
            transform: 'scale3d(.3, .3, .3)',
            offset: 0.5,
        }),
        style({
            opacity: 0,
            offset: 1,
        }),
    ])),
], {
    params: { timing: DEFAULT_TIMING, delay: 0 },
});
export function zoomOutY(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.550, 0.055, 0.675, 0.190)', keyframes([
        style({
            opacity: 1,
            transform: `scale3d(.475, .475, .475) translate3d(0, {{ a }}, 0)`,
            offset: 0.4,
        }),
        style({
            opacity: 0,
            transform: `scale3d(.1, .1, .1) translate3d(0, {{ b }}, 0)`,
            offset: 1,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export function zoomOutX(a, b) {
    return animation(animate('{{ timing }}s {{ delay }}s cubic-bezier(0.550, 0.055, 0.675, 0.190)', keyframes([
        style({
            opacity: 1,
            transform: `scale3d(.475, .475, .475) translate3d({{ a }}, 0, 0)`,
            offset: 0.4,
        }),
        style({
            opacity: 0,
            transform: `scale3d(.1, .1, .1) translate3d({{ b }}, 0, 0)`,
            offset: 1,
        }),
    ])), { params: { timing: DEFAULT_TIMING, delay: 0, a, b } });
}
export const zoomOutDown = zoomOutY('-60px', '2000px');
export const zoomOutUp = zoomOutY('60px', '-2000px');
export const zoomOutLeft = zoomOutX('42px', '-2000px');
export const zoomOutRight = zoomOutX('-42px', '2000px');
//# sourceMappingURL=data:application/json;base64,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