import { Directive, Inject, Input, Optional, } from '@angular/core';
import { DynamicComponentInjectorToken, } from '../component-injector';
import * as i0 from "@angular/core";
/**
 * @public
 */
export class DynamicAttributesDirective {
    constructor(renderer, differs, componentInjector) {
        this.renderer = renderer;
        this.differs = differs;
        this.componentInjector = componentInjector;
        this.attrsDiffer = this.differs.find({}).create();
    }
    get _attributes() {
        return (this.ndcDynamicAttributes ||
            this.ngComponentOutletNdcDynamicAttributes ||
            {});
    }
    get nativeElement() {
        return this.componentInjector?.componentRef?.location.nativeElement;
    }
    get compType() {
        return this.componentInjector?.componentRef?.componentType;
    }
    get isCompChanged() {
        if (this.lastCompType !== this.compType) {
            this.lastCompType = this.compType;
            return true;
        }
        return false;
    }
    ngDoCheck() {
        const isCompChanged = this.isCompChanged;
        const changes = this.attrsDiffer.diff(this._attributes);
        if (changes) {
            this.lastAttrActions = this.changesToAttrActions(changes);
        }
        if (changes || (isCompChanged && this.lastAttrActions)) {
            this.updateAttributes(this.lastAttrActions);
        }
    }
    setAttribute(name, value, namespace) {
        if (this.nativeElement) {
            this.renderer.setAttribute(this.nativeElement, name, value, namespace);
        }
    }
    removeAttribute(name, namespace) {
        if (this.nativeElement) {
            this.renderer.removeAttribute(this.nativeElement, name, namespace);
        }
    }
    updateAttributes(actions) {
        if (!this.compType || !actions) {
            return;
        }
        Object.keys(actions.set).forEach((key) => this.setAttribute(key, actions.set[key]));
        actions.remove.forEach((key) => this.removeAttribute(key));
    }
    changesToAttrActions(changes) {
        const attrActions = {
            set: {},
            remove: [],
        };
        changes.forEachAddedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachChangedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachRemovedItem((r) => attrActions.remove.push(r.key));
        return attrActions;
    }
}
/** @nocollapse */ DynamicAttributesDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: DynamicAttributesDirective, deps: [{ token: i0.Renderer2 }, { token: i0.KeyValueDiffers }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ DynamicAttributesDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.1.3", type: DynamicAttributesDirective, isStandalone: true, selector: "[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]", inputs: { ndcDynamicAttributes: "ndcDynamicAttributes", ngComponentOutletNdcDynamicAttributes: "ngComponentOutletNdcDynamicAttributes" }, exportAs: ["ndcDynamicAttributes"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.1.3", ngImport: i0, type: DynamicAttributesDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]',
                    exportAs: 'ndcDynamicAttributes',
                    standalone: true,
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.KeyValueDiffers }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicAttributes: [{
                type: Input
            }], ngComponentOutletNdcDynamicAttributes: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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